/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class AdvisoryOpenWireTest
extends BasicOpenWireTest {
    @Override
    @Before
    public void setUp() throws Exception {
        System.setProperty("org.apache.activemq.transport.AbstractInactivityMonitor.keepAliveTime", "2");
        this.realStore = true;
        super.setUp();
    }

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        ((TransportConfiguration)serverConfig.getAcceptorConfigurations().iterator().next()).getExtraParams().put("suppressInternalManagementObjects", "false");
        super.extraServerConfig(serverConfig);
    }

    @Test
    public void testTempTopicLeak() throws Exception {
        try (Connection connection = this.factory.createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            TemporaryTopic temporaryTopic = session.createTemporaryTopic();
            temporaryTopic.delete();
            AddressControl advisoryAddress = this.assertNonNullAddressControl("ActiveMQ.Advisory.TempTopic");
            Wait.waitFor(() -> advisoryAddress.getMessageCount() == 0L);
            Wait.assertEquals((long)0L, () -> ((AddressControl)advisoryAddress).getMessageCount());
            Wait.assertEquals((long)2L, () -> ((AddressControl)advisoryAddress).getRoutedMessageCount());
        }
    }

    private AddressControl assertNonNullAddressControl(String match) {
        Object[] addressResources;
        AddressControl advisoryAddressControl = null;
        for (Object addressResource : addressResources = this.server.getManagementService().getResources(AddressControl.class)) {
            if (!((AddressControl)addressResource).getAddress().equals(match)) continue;
            advisoryAddressControl = (AddressControl)addressResource;
        }
        AdvisoryOpenWireTest.assertNotNull((String)"addressControl for temp advisory", advisoryAddressControl);
        return advisoryAddressControl;
    }

    @Test
    public void testTempQueueLeak() throws Exception {
        try (Connection connection = this.factory.createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            TemporaryQueue temporaryQueue = session.createTemporaryQueue();
            temporaryQueue.delete();
            AddressControl advisoryAddress = this.assertNonNullAddressControl("ActiveMQ.Advisory.TempQueue");
            Wait.waitFor(() -> advisoryAddress.getMessageCount() == 0L);
            Wait.assertEquals((long)0L, () -> ((AddressControl)advisoryAddress).getMessageCount());
            Wait.assertEquals((long)2L, () -> ((AddressControl)advisoryAddress).getRoutedMessageCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTempQueueLeakManyConnections() throws Exception {
        Connection[] connections = new Connection[20];
        try {
            for (int i = 0; i < connections.length; ++i) {
                connections[i] = this.factory.createConnection();
                connections[i].start();
            }
            Session session = connections[0].createSession(false, 1);
            for (int i = 0; i < connections.length; ++i) {
                TemporaryQueue temporaryQueue = session.createTemporaryQueue();
                temporaryQueue.delete();
            }
            AddressControl advisoryAddress = this.assertNonNullAddressControl("ActiveMQ.Advisory.TempQueue");
            Wait.waitFor(() -> advisoryAddress.getMessageCount() == 0L);
            Wait.assertEquals((long)0L, () -> ((AddressControl)advisoryAddress).getMessageCount());
        }
        finally {
            for (Connection conn : connections) {
                if (conn == null) continue;
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongLivedConnectionGetsAllPastPrefetch() throws Exception {
        Connection[] connections = new Connection[2];
        int numTempDestinations = 600;
        try {
            for (int i = 0; i < connections.length; ++i) {
                connections[i] = this.factory.createConnection();
                connections[i].start();
            }
            Session session = connections[0].createSession(false, 1);
            for (int i = 0; i < 600; ++i) {
                TemporaryQueue temporaryQueue = session.createTemporaryQueue();
                temporaryQueue.delete();
            }
            AddressControl advisoryAddress = this.assertNonNullAddressControl("ActiveMQ.Advisory.TempQueue");
            Wait.waitFor(() -> advisoryAddress.getMessageCount() == 0L);
            Wait.assertEquals((long)0L, () -> ((AddressControl)advisoryAddress).getMessageCount());
            AdvisoryOpenWireTest.assertEquals((String)"all routed", (long)1200L, (long)advisoryAddress.getRoutedMessageCount());
        }
        finally {
            for (Connection conn : connections) {
                if (conn == null) continue;
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionAdvisory() throws Exception {
        Connection[] connections = new Connection[20];
        connections[0] = this.factory.createConnection();
        connections[0].start();
        CountDownLatch numConnectionsCreatedViaAdvisoryNotificationsLatch = new CountDownLatch(19);
        connections[0].createSession(false, 1).createConsumer((Destination)AdvisorySupport.getConnectionAdvisoryTopic()).setMessageListener(message -> numConnectionsCreatedViaAdvisoryNotificationsLatch.countDown());
        try {
            for (int i = 1; i < connections.length; ++i) {
                connections[i] = this.factory.createConnection();
                connections[i].start();
            }
            Session session = connections[0].createSession(false, 1);
            session.close();
            AdvisoryOpenWireTest.assertTrue((String)"Got all the advisories on time", (boolean)numConnectionsCreatedViaAdvisoryNotificationsLatch.await(5L, TimeUnit.SECONDS));
        }
        finally {
            for (Connection conn : connections) {
                if (conn == null) continue;
                conn.close();
            }
        }
    }
}

