/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.HashSet;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.Before;
import org.junit.Test;

public class SecurityOpenWireTest
extends BasicOpenWireTest {
    @Override
    @Before
    public void setUp() throws Exception {
        System.setProperty("org.apache.activemq.transport.AbstractInactivityMonitor.keepAliveTime", "2");
        this.realStore = true;
        this.enableSecurity = true;
        super.setUp();
    }

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        super.extraServerConfig(serverConfig);
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("denyQ", "denyQ");
        securityManager.getConfiguration().addRole("denyQ", "denyQ");
        securityManager.getConfiguration().addRole("denyQ", "advisoryReceiver");
    }

    @Test
    public void testSendNoAuth() throws Exception {
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", false, false, false, false, false, false, false, false, false, false));
        this.server.getSecurityRepository().addMatch("denyQ", roles);
        SimpleString denyQ = new SimpleString("denyQ");
        this.server.createQueue(new QueueConfiguration(denyQ).setRoutingType(RoutingType.ANYCAST));
        try (Connection connection = this.factory.createConnection("denyQ", "denyQ");){
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue("denyQ");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(2);
            try {
                producer.send((Message)session.createTextMessage());
                SecurityOpenWireTest.fail();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

