/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDeadlockOnPurgePagingTest
extends ActiveMQTestBase {
    private static final Logger logger = Logger.getLogger(TestDeadlockOnPurgePagingTest.class);
    protected ServerLocator locator;
    protected ActiveMQServer server;
    protected ClientSessionFactory sf;
    static final int MESSAGE_SIZE = 1024;
    static final int LARGE_MESSAGE_SIZE = 102400;
    protected static final int RECEIVE_TIMEOUT = 5000;
    protected static final int PAGE_MAX = 102400;
    protected static final int PAGE_SIZE = 10240;
    static final SimpleString ADDRESS = new SimpleString("SimpleAddress");

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testDeadlockOnPurge() throws Exception {
        int i;
        int NUMBER_OF_MESSAGES = 5000;
        this.clearDataRecreateServerDirs();
        Configuration config = this.createDefaultNettyConfig().setJournalSyncNonTransactional(false);
        this.server = this.createServer(true, config, 10240, 102400L);
        this.server.start();
        String queue = "purgeQueue";
        SimpleString ssQueue = new SimpleString(queue);
        this.server.addAddressInfo(new AddressInfo(ssQueue, RoutingType.ANYCAST));
        QueueImpl purgeQueue = (QueueImpl)this.server.createQueue(new QueueConfiguration(ssQueue).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(1)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setAutoCreateAddress(Boolean.valueOf(false)));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
        Connection connection = cf.createConnection();
        connection.start();
        Session session = connection.createSession(true, 0);
        Queue jmsQueue = session.createQueue(queue);
        MessageProducer producer = session.createProducer((Destination)jmsQueue);
        for (int i2 = 0; i2 < 100; ++i2) {
            producer.send((Message)session.createTextMessage("hello" + i2));
        }
        session.commit();
        Wait.assertEquals((long)0L, () -> ((QueueImpl)purgeQueue).getMessageCount());
        Wait.assertEquals((long)0L, () -> ((PagingStore)purgeQueue.getPageSubscription().getPagingStore()).getAddressSize());
        MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
        for (i = 0; i < NUMBER_OF_MESSAGES / 5; ++i) {
            producer.send((Message)session.createTextMessage("hello" + i));
            if (i == 10) {
                purgeQueue.getPageSubscription().getPagingStore().startPaging();
            }
            if (i <= 10 || i % 10 != 0) continue;
            purgeQueue.getPageSubscription().getPagingStore().forceAnotherPage();
        }
        session.commit();
        for (i = 0; i < 100; ++i) {
            Message message = consumer.receive(5000L);
            Assert.assertNotNull((Object)message);
        }
        session.commit();
        consumer.close();
        Wait.assertEquals((Long)0L, () -> ((QueueImpl)purgeQueue).getMessageCount(), (long)5000L, (long)10L);
        Wait.assertFalse(() -> ((PageSubscription)purgeQueue.getPageSubscription()).isPaging(), (long)5000L, (long)10L);
        Wait.assertEquals((Long)0L, () -> ((PagingStore)purgeQueue.getPageSubscription().getPagingStore()).getAddressSize(), (long)5000L, (long)10L);
    }
}

