/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.metrics.plugins.SimpleMetricsPlugin;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MetricsPluginTest
extends ActiveMQTestBase {
    private boolean legacyConfig;
    protected ActiveMQServer server;
    protected ClientSession session;
    protected ClientSessionFactory sf;
    protected ServerLocator locator;

    @Parameterized.Parameters(name="legacyConfig={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    public MetricsPluginTest(boolean legacyConfig) {
        this.legacyConfig = legacyConfig;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig());
        if (this.legacyConfig) {
            this.server.getConfiguration().setMetricsPlugin(new SimpleMetricsPlugin().init(null));
        } else {
            this.server.getConfiguration().setMetricsConfiguration(new MetricsConfiguration().setPlugin(new SimpleMetricsPlugin().init(null)));
        }
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }

    @Test
    public void testForArtemisMetricsPresence() throws Exception {
        class Metric {
            public final String name;
            public final String description;
            public final Double value;

            Metric(String name, String description, Double value) {
                this.name = name;
                this.description = description;
                this.value = value;
            }

            public String toString() {
                return this.name + ": " + this.value + " (" + this.description + ")";
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Metric metric = (Metric)o;
                return Objects.equals(this.name, metric.name) && Objects.equals(this.description, metric.description) && Objects.equals(this.value, metric.value);
            }

            public int hashCode() {
                return Objects.hash(this.name, this.description, this.value);
            }
        }
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        this.session.createQueue(new QueueConfiguration("simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        Map<Meter.Id, Double> metrics = this.getMetrics();
        List artemisMetrics = metrics.entrySet().stream().map(entry -> new Metric(((Meter.Id)entry.getKey()).getName(), ((Meter.Id)entry.getKey()).getDescription(), (Double)entry.getValue())).filter(metric -> metric.name.startsWith("artemis")).collect(Collectors.toList());
        MetricsPluginTest.assertThat(artemisMetrics, (Matcher)Matchers.containsInAnyOrder((Object[])new Metric[]{new Metric("artemis.address.memory.usage", "Memory used by all the addresses on broker for in-memory messages", 0.0), new Metric("artemis.address.memory.usage.percentage", "Memory used by all the addresses on broker as a percentage of the global-max-size", 0.0), new Metric("artemis.connection.count", "Number of clients connected to this server", 1.0), new Metric("artemis.consumer.count", "number of consumers consuming messages from this queue", 0.0), new Metric("artemis.delivering.durable.message.count", "number of durable messages that this queue is currently delivering to its consumers", 0.0), new Metric("artemis.delivering.durable.persistent.size", "persistent size of durable messages that this queue is currently delivering to its consumers", 0.0), new Metric("artemis.delivering.message.count", "number of messages that this queue is currently delivering to its consumers", 0.0), new Metric("artemis.delivering.persistent_size", "persistent size of messages that this queue is currently delivering to its consumers", 0.0), new Metric("artemis.disk.store.usage", "Fraction of total disk store used", 0.0), new Metric("artemis.durable.message.count", "number of durable messages currently in this queue (includes scheduled, paged, and in-delivery messages)", 0.0), new Metric("artemis.durable.persistent.size", "persistent size of durable messages currently in this queue (includes scheduled, paged, and in-delivery messages)", 0.0), new Metric("artemis.message.count", "number of messages currently in this queue (includes scheduled, paged, and in-delivery messages)", 0.0), new Metric("artemis.messages.acknowledged", "number of messages acknowledged from this queue since it was created", 0.0), new Metric("artemis.messages.added", "number of messages added to this queue since it was created", 0.0), new Metric("artemis.messages.expired", "number of messages expired from this queue since it was created", 0.0), new Metric("artemis.messages.killed", "number of messages removed from this queue since it was created due to exceeding the max delivery attempts", 0.0), new Metric("artemis.persistent.size", "persistent size of all messages (including durable and non-durable) currently in this queue (includes scheduled, paged, and in-delivery messages)", 0.0), new Metric("artemis.routed.message.count", "number of messages routed to one or more bindings", 0.0), new Metric("artemis.routed.message.count", "number of messages routed to one or more bindings", 0.0), new Metric("artemis.scheduled.durable.message.count", "number of durable scheduled messages in this queue", 0.0), new Metric("artemis.scheduled.durable.persistent.size", "persistent size of durable scheduled messages in this queue", 0.0), new Metric("artemis.scheduled.message.count", "number of scheduled messages in this queue", 0.0), new Metric("artemis.scheduled.persistent.size", "persistent size of scheduled messages in this queue", 0.0), new Metric("artemis.total.connection.count", "Number of clients which have connected to this server since it was started", 1.0), new Metric("artemis.unrouted.message.count", "number of messages not routed to any bindings", 0.0), new Metric("artemis.unrouted.message.count", "number of messages not routed to any bindings", 2.0), new Metric("artemis.address.size", "the number of estimated bytes being used by all the queue(s) bound to this address; used to control paging and blocking", 0.0), new Metric("artemis.address.size", "the number of estimated bytes being used by all the queue(s) bound to this address; used to control paging and blocking", 0.0), new Metric("artemis.number.of.pages", "number of pages used by this address", 0.0), new Metric("artemis.number.of.pages", "number of pages used by this address", 0.0)}));
    }

    @Test
    public void testForBasicMetricsPresenceAndValue() throws Exception {
        this.internalTestForBasicMetrics(true);
    }

    @Test
    public void testDisablingMetrics() throws Exception {
        this.internalTestForBasicMetrics(false);
    }

    private void internalTestForBasicMetrics(boolean enabled) throws Exception {
        String data = "Simple Text " + UUID.randomUUID().toString();
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("simpleAddress")).setEnableMetrics(enabled);
        this.session.createQueue(new QueueConfiguration("simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer("simpleAddress");
        ClientMessage message = this.session.createMessage(true);
        message.getBodyBuffer().writeString(data);
        producer.send((Message)message);
        producer.close();
        Queue queue = this.server.locateQueue("simpleQueue");
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        Map<Meter.Id, Double> metrics = this.getMetrics();
        this.checkMetric(metrics, "artemis.message.count", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.messages.added", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.messages.acknowledged", "queue", "simpleQueue", 0.0, enabled);
        this.checkMetric(metrics, "artemis.durable.message.count", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.delivering.message.count", "queue", "simpleQueue", 0.0, enabled);
        this.checkMetric(metrics, "artemis.routed.message.count", "address", "simpleAddress", 1.0, enabled);
        this.checkMetric(metrics, "artemis.unrouted.message.count", "address", "simpleAddress", 0.0, enabled);
        this.checkMetric(metrics, "artemis.consumer.count", "queue", "simpleQueue", 0.0, enabled);
        ClientConsumer consumer = this.session.createConsumer("simpleQueue");
        this.session.start();
        message = consumer.receive(1000L);
        MetricsPluginTest.assertNotNull((Object)message);
        metrics = this.getMetrics();
        this.checkMetric(metrics, "artemis.delivering.message.count", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.consumer.count", "queue", "simpleQueue", 1.0, enabled);
        message.acknowledge();
        MetricsPluginTest.assertEquals((Object)data, (Object)message.getBodyBuffer().readString());
        this.session.commit();
        MetricsPluginTest.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(SimpleString.toSimpleString((String)"simpleQueue")).getMessagesAcknowledged() == 1L, (long)1000L, (long)100L));
        consumer.close();
        metrics = this.getMetrics();
        this.checkMetric(metrics, "artemis.message.count", "queue", "simpleQueue", 0.0, enabled);
        this.checkMetric(metrics, "artemis.messages.added", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.messages.acknowledged", "queue", "simpleQueue", 1.0, enabled);
        this.checkMetric(metrics, "artemis.durable.message.count", "queue", "simpleQueue", 0.0, enabled);
        this.checkMetric(metrics, "artemis.delivering.message.count", "queue", "simpleQueue", 0.0, enabled);
        this.checkMetric(metrics, "artemis.routed.message.count", "address", "simpleAddress", 1.0, enabled);
        this.checkMetric(metrics, "artemis.unrouted.message.count", "address", "simpleAddress", 0.0, enabled);
        this.checkMetric(metrics, "artemis.consumer.count", "queue", "simpleQueue", 0.0, enabled);
    }

    @Test
    public void testMessageCountWithPaging() throws Exception {
        String data = "Simple Text " + UUID.randomUUID().toString();
        String queueName = "simpleQueue";
        String addressName = "simpleAddress";
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("simpleAddress")).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setMaxSizeBytes(10240L).setPageSizeBytes(5120);
        this.session.createQueue(new QueueConfiguration("simpleQueue").setAddress("simpleAddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.session.createProducer("simpleAddress");
        ClientMessage message = this.session.createMessage(true);
        message.getBodyBuffer().writeString(data);
        long messageCount = 0L;
        while (!this.server.getPagingManager().getPageStore(new SimpleString("simpleAddress")).isPaging()) {
            producer.send((Message)message);
            ++messageCount;
        }
        Wait.assertEquals((Long)messageCount, () -> ((Queue)this.server.locateQueue("simpleQueue")).getMessageCount(), (long)2000L, (long)100L);
        this.checkMetric(this.getMetrics(), "artemis.message.count", "queue", "simpleQueue", Double.valueOf(messageCount));
        int i = 0;
        while ((long)i < messageCount) {
            producer.send((Message)message);
            ++i;
        }
        producer.close();
        Wait.assertEquals((Long)(messageCount * 2L), () -> ((Queue)this.server.locateQueue("simpleQueue")).getMessageCount(), (long)2000L, (long)100L);
        this.checkMetric(this.getMetrics(), "artemis.message.count", "queue", "simpleQueue", Double.valueOf(messageCount * 2L));
    }

    public Map<Meter.Id, Double> getMetrics() {
        return MetricsPluginTest.getMetrics(this.server);
    }

    public static Map<Meter.Id, Double> getMetrics(ActiveMQServer server) {
        HashMap<Meter.Id, Double> metrics = new HashMap<Meter.Id, Double>();
        List meters = server.getMetricsManager().getMeterRegistry().getMeters();
        MetricsPluginTest.assertTrue((meters.size() > 0 ? (byte)1 : 0) != 0);
        for (Meter meter : meters) {
            Iterable measurements = meter.measure();
            for (Measurement measurement : measurements) {
                metrics.put(meter.getId(), measurement.getValue());
            }
        }
        return metrics;
    }

    public void checkMetric(Map<Meter.Id, Double> metrics, String metric, String tag, String tagValue, Double expectedValue) {
        this.checkMetric(metrics, metric, tag, tagValue, expectedValue, true);
    }

    public void checkMetric(Map<Meter.Id, Double> metrics, String metric, String tag, String tagValue, Double expectedValue, boolean enabled) {
        OptionalDouble actualValue = metrics.entrySet().stream().filter(entry -> metric.equals(((Meter.Id)entry.getKey()).getName())).filter(entry -> tagValue.equals(((Meter.Id)entry.getKey()).getTag(tag))).mapToDouble(Map.Entry::getValue).findFirst();
        if (enabled) {
            MetricsPluginTest.assertTrue((String)(metric + " for " + tag + " " + tagValue + " not present"), (boolean)actualValue.isPresent());
            MetricsPluginTest.assertEquals((String)(metric + " not equal"), (double)expectedValue, (double)actualValue.getAsDouble(), (double)0.0);
        } else {
            MetricsPluginTest.assertFalse((String)(metric + " for " + tag + " " + tagValue + " present"), (boolean)actualValue.isPresent());
        }
    }
}

