/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.plugin.impl.LoggingActiveMQServerPlugin;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.tests.integration.plugin.ConfigurationVerifier;
import org.apache.activemq.artemis.tests.integration.plugin.MethodCalledVerifier;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Test;

public class XmlConfigPluginTest
extends ActiveMQTestBase {
    @Test
    public void testStopStart1() throws Exception {
        ActiveMQServer server = this.createServerFromConfig("broker-plugins-config.xml");
        try {
            server.start();
            XmlConfigPluginTest.assertEquals((long)2L, (long)server.getBrokerPlugins().size());
            XmlConfigPluginTest.assertTrue((boolean)(server.getBrokerPlugins().get(0) instanceof MethodCalledVerifier));
            XmlConfigPluginTest.assertTrue((boolean)(server.getBrokerPlugins().get(1) instanceof ConfigurationVerifier));
            ConfigurationVerifier configurationVerifier = (ConfigurationVerifier)server.getBrokerPlugins().get(1);
            XmlConfigPluginTest.assertEquals((String)"value1", (Object)"val_1", (Object)configurationVerifier.value1);
            XmlConfigPluginTest.assertEquals((String)"value2", (Object)"val_2", (Object)configurationVerifier.value2);
            XmlConfigPluginTest.assertNull((String)"value3 should not have been set", (Object)configurationVerifier.value3);
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    @Test
    public void testLoggingActiveMQServerPlugin() throws Exception {
        ActiveMQServer server = this.createServerFromConfig("broker-logging-plugin.xml");
        try {
            server.start();
            XmlConfigPluginTest.assertEquals((String)"only one plugin should be registered", (long)1L, (long)server.getBrokerPlugins().size());
            XmlConfigPluginTest.assertTrue((String)"ensure LoggingActiveMQServerPlugin is registered", (boolean)(server.getBrokerPlugins().get(0) instanceof LoggingActiveMQServerPlugin));
            LoggingActiveMQServerPlugin loggingActiveMQServerPlugin = (LoggingActiveMQServerPlugin)server.getBrokerPlugins().get(0);
            XmlConfigPluginTest.assertEquals((String)"check logAll", (Object)true, (Object)loggingActiveMQServerPlugin.isLogAll());
            XmlConfigPluginTest.assertEquals((String)"check logConnectionEvents", (Object)true, (Object)loggingActiveMQServerPlugin.isLogConnectionEvents());
            XmlConfigPluginTest.assertEquals((String)"check logSessionEvents", (Object)true, (Object)loggingActiveMQServerPlugin.isLogSessionEvents());
            XmlConfigPluginTest.assertEquals((String)"check logConsumerEvents", (Object)true, (Object)loggingActiveMQServerPlugin.isLogConsumerEvents());
            XmlConfigPluginTest.assertEquals((String)"check logDeliveringEvents", (Object)true, (Object)loggingActiveMQServerPlugin.isLogDeliveringEvents());
            XmlConfigPluginTest.assertEquals((String)"check logSendingEvents", (Object)true, (Object)loggingActiveMQServerPlugin.isLogSendingEvents());
            XmlConfigPluginTest.assertEquals((String)"check logInternalEvents", (Object)true, (Object)loggingActiveMQServerPlugin.isLogInternalEvents());
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    @Test
    public void testLoggingActiveMQServerPluginWrongValue() throws Exception {
        ActiveMQServer server = this.createServerFromConfig("broker-logging-plugin-wrong.xml");
        try {
            server.start();
            XmlConfigPluginTest.assertEquals((String)"only one plugin should be registered", (long)1L, (long)server.getBrokerPlugins().size());
            XmlConfigPluginTest.assertTrue((String)"ensure LoggingActiveMQServerPlugin is registered", (boolean)(server.getBrokerPlugins().get(0) instanceof LoggingActiveMQServerPlugin));
            LoggingActiveMQServerPlugin loggingActiveMQServerPlugin = (LoggingActiveMQServerPlugin)server.getBrokerPlugins().get(0);
            XmlConfigPluginTest.assertEquals((String)"check logAll", (Object)false, (Object)loggingActiveMQServerPlugin.isLogAll());
            XmlConfigPluginTest.assertEquals((String)"check logConnectionEvents", (Object)false, (Object)loggingActiveMQServerPlugin.isLogConnectionEvents());
            XmlConfigPluginTest.assertEquals((String)"check logSessionEvents", (Object)false, (Object)loggingActiveMQServerPlugin.isLogSessionEvents());
            XmlConfigPluginTest.assertEquals((String)"check logConsumerEvents", (Object)false, (Object)loggingActiveMQServerPlugin.isLogConsumerEvents());
            XmlConfigPluginTest.assertEquals((String)"check logDeliveringEvents", (Object)false, (Object)loggingActiveMQServerPlugin.isLogDeliveringEvents());
            XmlConfigPluginTest.assertEquals((String)"check logSendingEvents", (Object)false, (Object)loggingActiveMQServerPlugin.isLogSendingEvents());
            XmlConfigPluginTest.assertEquals((String)"check logInternalEvents", (Object)false, (Object)loggingActiveMQServerPlugin.isLogInternalEvents());
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    private ActiveMQServer createServerFromConfig(String configFileName) throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileJMSConfiguration fileConfiguration = new FileJMSConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(configFileName);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.addDeployable((Deployable)fileConfiguration);
        deploymentManager.readConfiguration();
        return this.addServer((ActiveMQServer)new ActiveMQServerImpl((Configuration)fc));
    }
}

