/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.replication;

import java.io.IOException;
import java.util.Collections;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.quorum.file.FileBasedPrimitiveManager;
import org.apache.activemq.artemis.tests.integration.replication.SharedNothingReplicationFlowControlTest;
import org.junit.Before;

public class PluggableQuorumReplicationFlowControlTest
extends SharedNothingReplicationFlowControlTest {
    private DistributedPrimitiveManagerConfiguration managerConfiguration;

    @Before
    public void init() throws IOException {
        this.managerConfiguration = new DistributedPrimitiveManagerConfiguration(FileBasedPrimitiveManager.class.getName(), Collections.singletonMap("locks-folder", this.temporaryFolder.newFolder("manager").toString()));
    }

    @Override
    protected HAPolicyConfiguration createReplicationBackupConfiguration() {
        ReplicationBackupPolicyConfiguration haPolicy = ReplicationBackupPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        haPolicy.setClusterName("cluster");
        return haPolicy;
    }

    @Override
    protected HAPolicyConfiguration createReplicationLiveConfiguration() {
        ReplicationPrimaryPolicyConfiguration haPolicy = ReplicationPrimaryPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        return haPolicy;
    }
}

