/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrameInterceptor;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.felix.resolver.util.ArrayMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StompPropertiesInterceptorTest
extends StompTestBase {
    private static final String MESSAGE_TEXT = "messageText";
    private static final String MY_HEADER = "my-header";
    private static Map<String, Object> expectedProperties = new ArrayMap();

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"ws+v12.stomp"}, {"tcp+v12.stomp"});
    }

    @Override
    public List<String> getIncomingInterceptors() {
        ArrayList<String> stompIncomingInterceptor = new ArrayList<String>();
        stompIncomingInterceptor.add("org.apache.activemq.artemis.tests.integration.stomp.StompPropertiesInterceptorTest$StompFramePropertiesInterceptor");
        return stompIncomingInterceptor;
    }

    @Override
    public List<String> getOutgoingInterceptors() {
        ArrayList<String> stompOutgoingInterceptor = new ArrayList<String>();
        stompOutgoingInterceptor.add("org.apache.activemq.artemis.tests.integration.stomp.StompPropertiesInterceptorTest$StompFramePropertiesInterceptor");
        return stompOutgoingInterceptor;
    }

    @Test(timeout=60000L)
    public void testCheckInterceptedStompMessageProperties() throws Exception {
        String msgText = "Test intercepted message";
        String myHeader = "TestInterceptedHeader";
        expectedProperties.put(MESSAGE_TEXT, "Test intercepted message");
        expectedProperties.put(MY_HEADER, "TestInterceptedHeader");
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        ClientStompFrame subFrame = conn.createFrame("SUBSCRIBE");
        subFrame.addHeader("subscription-type", "ANYCAST");
        subFrame.addHeader("destination", this.name.getMethodName());
        subFrame.addHeader("ack", "auto");
        subFrame.addHeader(MY_HEADER, "TestInterceptedHeader");
        subFrame.setBody("Test intercepted message");
        conn.sendFrame(subFrame);
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", this.name.getMethodName());
        frame.addHeader("ack", "auto");
        frame.addHeader(MY_HEADER, "TestInterceptedHeader");
        conn.sendFrame(frame);
        conn.disconnect();
    }

    public static class StompFramePropertiesInterceptor
    implements StompFrameInterceptor {
        public boolean intercept(StompFrame stompFrame, RemotingConnection connection) {
            if (stompFrame.getCommand().equals("CONNECT") || stompFrame.getCommand().equals("CONNECTED")) {
                return true;
            }
            Assert.assertNotNull((Object)stompFrame);
            Assert.assertEquals((Object)stompFrame.getHeader(StompPropertiesInterceptorTest.MY_HEADER), expectedProperties.get(StompPropertiesInterceptorTest.MY_HEADER));
            Assert.assertEquals((Object)stompFrame.getBody(), expectedProperties.get(StompPropertiesInterceptorTest.MESSAGE_TEXT));
            return true;
        }
    }
}

