/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.net.URI;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StompTestMultiThreaded
extends StompTestBase {
    private static final SimpleString QUEUE = new SimpleString("x");

    @Test
    public void testTwoConcurrentSubscribers() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoDeleteAddresses(Boolean.valueOf(false)).setAutoDeleteQueues(Boolean.valueOf(false)));
        this.server.getRemotingService().createAcceptor("test", "tcp://localhost:61614?protocols=STOMP&anycastPrefix=/queue/").start();
        int nThreads = 2;
        SomeConsumer[] consumers = new SomeConsumer[nThreads];
        for (int j = 0; j < 1000; ++j) {
            int i;
            for (i = 0; i < nThreads; ++i) {
                consumers[i] = new SomeConsumer();
            }
            for (i = 0; i < nThreads; ++i) {
                consumers[i].start();
            }
            for (SomeConsumer consumer : consumers) {
                consumer.join();
                Assert.assertFalse((boolean)consumer.failed);
            }
            this.server.locateQueue(QUEUE).deleteQueue();
        }
    }

    class SomeConsumer
    extends Thread {
        private final StompClientConnection conn;
        boolean failed = false;

        SomeConsumer() throws Exception {
            URI uri = StompTestBase.createStompClientUri(StompTestMultiThreaded.this.scheme, "localhost", 61614);
            this.conn = StompClientConnectionFactory.createClientConnection(uri);
        }

        @Override
        public void run() {
            try {
                this.conn.connect(StompTestMultiThreaded.this.defUser, StompTestMultiThreaded.this.defPass);
                if (!StompTestBase.subscribe(this.conn, UUID.randomUUID().toString(), "auto", null, null, "/queue/" + QUEUE, true).getCommand().equals("RECEIPT")) {
                    this.failed = true;
                }
            }
            catch (Throwable e) {
                this.failed = true;
            }
            finally {
                try {
                    this.conn.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }
}

