/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.io.File;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.FakeSequentialFileFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class CleanBufferTest
extends ActiveMQTestBase {
    @Test
    public void testCleanOnNIO() {
        NIOSequentialFileFactory factory = new NIOSequentialFileFactory(new File("Whatever"), 1);
        this.testBuffer((SequentialFileFactory)factory);
    }

    @Test
    public void testCleanOnAIO() {
        if (LibaioContext.isLoaded()) {
            AIOSequentialFileFactory factory = new AIOSequentialFileFactory(new File("./target"), 50);
            this.testBuffer((SequentialFileFactory)factory);
        }
    }

    @Test
    public void testCleanOnFake() {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        this.testBuffer(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBuffer(SequentialFileFactory factory) {
        factory.start();
        ByteBuffer buffer = factory.newBuffer(100);
        try {
            byte b;
            for (b = 0; b < 100; b = (byte)(b + 1)) {
                buffer.put(b);
            }
            buffer.rewind();
            for (b = 0; b < 100; b = (byte)(b + 1)) {
                Assert.assertEquals((long)b, (long)buffer.get());
            }
            buffer.limit(10);
            factory.clearBuffer(buffer);
            buffer.limit(100);
            buffer.rewind();
            for (b = 0; b < 100; b = (byte)(b + 1)) {
                if (b < 10) {
                    Assert.assertEquals((long)0L, (long)buffer.get());
                    continue;
                }
                Assert.assertEquals((long)b, (long)buffer.get());
            }
        }
        finally {
            factory.releaseBuffer(buffer);
            factory.stop();
        }
    }
}

