/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.io.DummyCallback;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.io.buffer.TimedBufferObserver;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TimedBufferTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(TimedBufferTest.class);
    private static final int ONE_SECOND_IN_NANOS = 1000000000;
    IOCallback dummyCallback = new IOCallback(){

        public void done() {
        }

        public void onError(int errorCode, String errorMessage) {
        }
    };
    private static final EncodingSupport LONG_ENCODER = new EncodingSupport(){

        public int getEncodeSize() {
            return 8;
        }

        public void encode(ActiveMQBuffer buffer) {
            buffer.writeLong(1L);
        }

        public void decode(ActiveMQBuffer buffer) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFillBuffer() {
        final ArrayList buffers = new ArrayList();
        final AtomicInteger flushTimes = new AtomicInteger(0);
        TimedBuffer timedBuffer = new TimedBuffer(null, 100, 1000000000, false);
        timedBuffer.start();
        try {
            class TestObserver
            implements TimedBufferObserver {
                TestObserver() {
                }

                public void flushBuffer(ByteBuf byteBuf, boolean sync, List<IOCallback> callbacks) {
                    ByteBuffer buffer = ByteBuffer.allocate(byteBuf.readableBytes());
                    buffer.limit(byteBuf.readableBytes());
                    byteBuf.getBytes(byteBuf.readerIndex(), buffer);
                    buffer.flip();
                    buffers.add(buffer);
                    flushTimes.incrementAndGet();
                }

                public int getRemainingBytes() {
                    return 0x100000;
                }
            }
            timedBuffer.setObserver((TimedBufferObserver)new TestObserver());
            int x = 0;
            for (int i = 0; i < 10; ++i) {
                byte[] bytes = new byte[10];
                for (int j = 0; j < 10; ++j) {
                    bytes[j] = ActiveMQTestBase.getSamplebyte((long)x++);
                }
                ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])bytes);
                timedBuffer.checkSize(10);
                timedBuffer.addBytes(buff, false, this.dummyCallback);
            }
            timedBuffer.checkSize(1);
            Assert.assertEquals((long)1L, (long)flushTimes.get());
            ByteBuffer flushedBuffer = (ByteBuffer)buffers.get(0);
            Assert.assertEquals((long)100L, (long)flushedBuffer.limit());
            Assert.assertEquals((long)100L, (long)flushedBuffer.capacity());
            flushedBuffer.rewind();
            for (int i = 0; i < 100; ++i) {
                Assert.assertEquals((long)ActiveMQTestBase.getSamplebyte((long)i), (long)flushedBuffer.get());
            }
        }
        finally {
            timedBuffer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeOnTimedBuffer() throws Exception {
        final ReusableLatch latchFlushed = new ReusableLatch(0);
        AtomicInteger flushes = new AtomicInteger(0);
        TimedBuffer timedBuffer = new TimedBuffer(null, 100, 500000000, false);
        timedBuffer.start();
        class TestObserver
        implements TimedBufferObserver {
            TestObserver() {
            }

            public void flushBuffer(ByteBuf byteBuf, boolean sync, List<IOCallback> callbacks) {
                ByteBuffer buffer = ByteBuffer.allocate(byteBuf.readableBytes());
                buffer.limit(byteBuf.readableBytes());
                byteBuf.getBytes(byteBuf.readerIndex(), buffer);
                for (IOCallback callback : callbacks) {
                    callback.done();
                }
            }

            public int getRemainingBytes() {
                return 0x100000;
            }
        }
        TestObserver observer = new TestObserver();
        timedBuffer.setObserver((TimedBufferObserver)observer);
        int x = 0;
        byte[] bytes = new byte[10];
        for (int j = 0; j < 10; ++j) {
            bytes[j] = ActiveMQTestBase.getSamplebyte((long)x++);
        }
        ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])bytes);
        IOCallback callback = new IOCallback(){

            public void done() {
                log.debug((Object)"done");
                latchFlushed.countDown();
            }

            public void onError(int errorCode, String errorMessage) {
            }
        };
        try {
            latchFlushed.setCount(2);
            timedBuffer.addBytes(buff, true, callback);
            Thread.sleep(1000L);
            timedBuffer.addBytes(buff, true, callback);
            Assert.assertTrue((boolean)latchFlushed.await(5L, TimeUnit.SECONDS));
            latchFlushed.setCount(5);
            flushes.set(0);
            long time = System.currentTimeMillis();
            for (int i = 0; i < 5; ++i) {
                timedBuffer.addBytes(buff, true, callback);
                Thread.sleep(1L);
            }
            Assert.assertTrue((boolean)latchFlushed.await(5L, TimeUnit.SECONDS));
            Assert.assertTrue((String)("Timed Buffer is not batching accordingly, it was expected to take at least 500 seconds batching multiple writes while it took " + (System.currentTimeMillis() - time) + " milliseconds"), (System.currentTimeMillis() - time >= 450L ? (byte)1 : 0) != 0);
            Assert.assertTrue((String)"Too many writes were called", (flushes.get() <= 3 ? (byte)1 : 0) != 0);
        }
        finally {
            timedBuffer.stop();
        }
    }

    private static void spinSleep(long timeout) {
        if (timeout > 0L) {
            long deadline = System.nanoTime() + timeout;
            while (System.nanoTime() - deadline < 0L) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timeoutShouldMatchFlushIOPSWithNotBlockingFlush() {
        long timeout = TimeUnit.MILLISECONDS.toNanos(100L);
        assert ((int)timeout > 0);
        long deviceTime = timeout;
        int bufferSize = Env.osPageSize();
        TimedBuffer timedBuffer = new TimedBuffer(null, bufferSize, (int)timeout, false);
        timedBuffer.start();
        try (NonBlockingObserver observer = new NonBlockingObserver(bufferSize, deviceTime);){
            timedBuffer.setObserver((TimedBufferObserver)observer);
            timedBuffer.addBytes(LONG_ENCODER, true, (IOCallback)DummyCallback.getInstance());
            observer.waitUntilFlushIsDone(1L);
            assert (observer.flushesDone() == 1L);
            timedBuffer.addBytes(LONG_ENCODER, true, (IOCallback)DummyCallback.getInstance());
            long endOfWriteRequest = System.nanoTime();
            observer.waitUntilFlushIsDone(2L);
            long flushDone = System.nanoTime();
            long elapsedTime = flushDone - endOfWriteRequest;
            assert (observer.flushesDone() == 2L);
            log.debug((Object)("elapsed time: " + elapsedTime + " with timeout: " + timeout));
            long maxExpected = timeout + deviceTime;
            Assert.assertTrue((String)("elapsed = " + elapsedTime + " max expected = " + maxExpected), (elapsedTime <= maxExpected ? (byte)1 : 0) != 0);
        }
        finally {
            timedBuffer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timeoutShouldMatchFlushIOPSWithBlockingFlush() {
        long timeout = TimeUnit.MILLISECONDS.toNanos(100L);
        assert ((int)timeout > 0);
        long deviceTime = timeout;
        int bufferSize = Env.osPageSize();
        TimedBuffer timedBuffer = new TimedBuffer(null, bufferSize, (int)timeout, false);
        timedBuffer.start();
        try (BlockingObserver observer = new BlockingObserver(bufferSize, deviceTime);){
            timedBuffer.setObserver((TimedBufferObserver)observer);
            timedBuffer.addBytes(LONG_ENCODER, true, (IOCallback)DummyCallback.getInstance());
            observer.waitUntilFlushIsDone(1L);
            assert (observer.flushesDone() == 1L);
            timedBuffer.addBytes(LONG_ENCODER, true, (IOCallback)DummyCallback.getInstance());
            long endOfWriteRequest = System.nanoTime();
            observer.waitUntilFlushIsDone(2L);
            long flushDone = System.nanoTime();
            long elapsedTime = flushDone - endOfWriteRequest;
            assert (observer.flushesDone() == 2L);
            log.debug((Object)("elapsed time: " + elapsedTime + " with timeout: " + timeout));
            long maxExpected = timeout + deviceTime;
            Assert.assertTrue((String)("elapsed = " + elapsedTime + " max expected = " + maxExpected), (elapsedTime <= maxExpected ? (byte)1 : 0) != 0);
        }
        finally {
            timedBuffer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimingAndFlush() throws Exception {
        final ArrayList buffers = new ArrayList();
        final AtomicInteger flushTimes = new AtomicInteger(0);
        TimedBuffer timedBuffer = new TimedBuffer(null, 100, 100000000, false);
        timedBuffer.start();
        try {
            class TestObserver
            implements TimedBufferObserver {
                TestObserver() {
                }

                public void flushBuffer(ByteBuf byteBuf, boolean sync, List<IOCallback> callbacks) {
                    ByteBuffer buffer = ByteBuffer.allocate(byteBuf.readableBytes());
                    buffer.limit(byteBuf.readableBytes());
                    byteBuf.getBytes(byteBuf.readerIndex(), buffer);
                    buffer.flip();
                    buffers.add(buffer);
                    flushTimes.incrementAndGet();
                }

                public int getRemainingBytes() {
                    return 0x100000;
                }
            }
            timedBuffer.setObserver((TimedBufferObserver)new TestObserver());
            int x = 0;
            byte[] bytes = new byte[10];
            for (int j = 0; j < 10; ++j) {
                bytes[j] = ActiveMQTestBase.getSamplebyte((long)x++);
            }
            ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])bytes);
            timedBuffer.checkSize(10);
            timedBuffer.addBytes(buff, false, this.dummyCallback);
            Thread.sleep(200L);
            Assert.assertEquals((long)0L, (long)flushTimes.get());
            bytes = new byte[10];
            for (int j = 0; j < 10; ++j) {
                bytes[j] = ActiveMQTestBase.getSamplebyte((long)x++);
            }
            buff = ActiveMQBuffers.wrappedBuffer((byte[])bytes);
            timedBuffer.checkSize(10);
            timedBuffer.addBytes(buff, true, this.dummyCallback);
            Thread.sleep(500L);
            Assert.assertEquals((long)1L, (long)flushTimes.get());
            ByteBuffer flushedBuffer = (ByteBuffer)buffers.get(0);
            Assert.assertEquals((long)20L, (long)flushedBuffer.limit());
            Assert.assertEquals((long)20L, (long)flushedBuffer.capacity());
            flushedBuffer.rewind();
            for (int i = 0; i < 20; ++i) {
                Assert.assertEquals((long)ActiveMQTestBase.getSamplebyte((long)i), (long)flushedBuffer.get());
            }
        }
        finally {
            timedBuffer.stop();
        }
    }

    private static final class BlockingObserver
    implements TimedBufferObserver,
    AutoCloseable {
        private long flushes = 0L;
        private final ByteBuffer dummyBuffer;
        private final long deviceTime;
        private final AtomicLong flushesDone = new AtomicLong(0L);

        private BlockingObserver(int bufferSize, long deviceTime) {
            this.dummyBuffer = ByteBuffer.allocate(bufferSize);
            this.deviceTime = deviceTime;
        }

        public void flushBuffer(ByteBuf byteBuf, boolean sync, List<IOCallback> callbacks) {
            assert (sync);
            this.dummyBuffer.limit(byteBuf.readableBytes());
            byteBuf.getBytes(byteBuf.readerIndex(), this.dummyBuffer);
            if (this.dummyBuffer.position() > 0) {
                this.dummyBuffer.clear();
                TimedBufferTest.spinSleep(this.deviceTime);
                ++this.flushes;
                this.flushesDone.lazySet(this.flushes);
            }
        }

        public int getRemainingBytes() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void close() {
        }

        public void waitUntilFlushIsDone(long flush) {
            while (this.flushesDone.get() < flush) {
            }
        }

        public long flushesDone() {
            return this.flushesDone.get();
        }
    }

    private static final class NonBlockingObserver
    implements TimedBufferObserver,
    AutoCloseable {
        private long flushes = 0L;
        private final ByteBuffer dummyBuffer;
        private final Thread asyncIOWriter;
        private final AtomicLong flushRequest = new AtomicLong(0L);
        private final AtomicLong flushesDone = new AtomicLong(0L);

        private NonBlockingObserver(int bufferSize, long deviceTime) {
            this.asyncIOWriter = new Thread(() -> {
                long flushes = 0L;
                while (!Thread.interrupted()) {
                    if (this.flushRequest.get() <= flushes) continue;
                    long flushesToBePerformed = this.flushRequest.get() - flushes;
                    int i = 0;
                    while ((long)i < flushesToBePerformed) {
                        TimedBufferTest.spinSleep(deviceTime);
                        this.flushesDone.lazySet(++flushes);
                        ++i;
                    }
                }
            });
            this.dummyBuffer = ByteBuffer.allocate(bufferSize);
            this.asyncIOWriter.start();
        }

        public void flushBuffer(ByteBuf byteBuf, boolean sync, List<IOCallback> callbacks) {
            assert (sync);
            this.dummyBuffer.limit(byteBuf.readableBytes());
            byteBuf.getBytes(byteBuf.readerIndex(), this.dummyBuffer);
            if (this.dummyBuffer.position() > 0) {
                this.dummyBuffer.clear();
                ++this.flushes;
                this.flushRequest.lazySet(this.flushes);
            }
        }

        public int getRemainingBytes() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void close() {
            this.asyncIOWriter.interrupt();
        }

        public void waitUntilFlushIsDone(long flush) {
            while (this.flushesDone.get() < flush) {
            }
        }

        public long flushesDone() {
            return this.flushesDone.get();
        }
    }
}

