/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.postoffice.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Address;
import org.apache.activemq.artemis.core.postoffice.impl.AddressImpl;
import org.apache.activemq.artemis.core.postoffice.impl.AddressMap;
import org.apache.activemq.artemis.core.postoffice.impl.AddressMapVisitor;
import org.junit.Assert;
import org.junit.Test;

public class AddressMapUnitTest {
    AddressMap<SimpleString> underTest = new AddressMap("#", "*", '.');

    @Test
    public void testAddGetRemove() throws Exception {
        SimpleString a = new SimpleString("a.b.c");
        Assert.assertTrue((boolean)this.isEmpty(a));
        this.underTest.put(a, (Object)a);
        Assert.assertFalse((boolean)this.isEmpty(a));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(a));
        this.underTest.remove(a, (Object)a);
        Assert.assertTrue((boolean)this.isEmpty(a));
    }

    private boolean isEmpty(SimpleString match) throws Exception {
        return this.countMatchingWildcards(match) == 0;
    }

    @Test
    public void testWildcardAddGet() throws Exception {
        SimpleString a = new SimpleString("a.*.c");
        Assert.assertTrue((boolean)this.isEmpty(a));
        this.underTest.put(a, (Object)a);
        Assert.assertFalse((boolean)this.isEmpty(a));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(a));
        this.underTest.remove(a, (Object)a);
        Assert.assertTrue((boolean)this.isEmpty(a));
    }

    @Test
    public void testWildcardAllAddGet() throws Exception {
        SimpleString a = new SimpleString("a.b.#");
        Assert.assertTrue((boolean)this.isEmpty(a));
        this.underTest.put(a, (Object)a);
        Assert.assertFalse((boolean)this.isEmpty(a));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(a));
        this.underTest.remove(a, (Object)a);
        Assert.assertTrue((boolean)this.isEmpty(a));
    }

    @Test
    public void testNoDots() throws Exception {
        SimpleString s1 = new SimpleString("abcde");
        SimpleString s2 = new SimpleString("abcde");
        this.underTest.put(s1, (Object)s1);
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(s2));
    }

    @Test
    public void testDotsSameLength2() throws Exception {
        SimpleString s1 = new SimpleString("a.b");
        SimpleString s2 = new SimpleString("a.b");
        this.underTest.put(s1, (Object)s1);
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(s2));
    }

    @Test
    public void testA() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c");
        SimpleString s2 = new SimpleString("a.b.c.d.e.f.g.h.i.j.k.l.m.n.*");
        this.underTest.put(s1, (Object)s1);
        Assert.assertEquals((long)0L, (long)this.countMatchingWildcards(s2));
    }

    @Test
    public void testB() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s2 = new SimpleString("a.b.x.e");
        SimpleString s3 = new SimpleString("a.b.c.*");
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testC() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s2 = new SimpleString("a.b.c.x");
        SimpleString s3 = new SimpleString("a.b.*.d");
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testD() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d.e");
        SimpleString s2 = new SimpleString("a.b.c.x.e");
        SimpleString s3 = new SimpleString("a.b.*.d.*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testE() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("a.b.*.d.*.f");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testF() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertTrue((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)2L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testG() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("a.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertTrue((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)2L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testH() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("#.b.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertTrue((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)2L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testI() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("a.#.b.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertTrue((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)2L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testJ() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.x.e.f");
        SimpleString s3 = new SimpleString("a.#.c.d.e.f");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testK() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.d.e.x");
        SimpleString s3 = new SimpleString("a.#.c.d.e.*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertTrue((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)2L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testL() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d.e.f");
        SimpleString s2 = new SimpleString("a.b.c.d.e.x");
        SimpleString s3 = new SimpleString("a.#.c.d.*.f");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testM() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c");
        SimpleString s2 = new SimpleString("a.b.x.e");
        SimpleString s3 = new SimpleString("a.b.c.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testN() throws Exception {
        SimpleString s1 = new SimpleString("usd.stock");
        SimpleString s2 = new SimpleString("a.b.x.e");
        SimpleString s3 = new SimpleString("*.stock.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testO() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s2 = new SimpleString("a.b.x.e");
        SimpleString s3 = new SimpleString("a.b.c.*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        Assert.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testP() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("a.b.c#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assert.assertEquals((long)0L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testQ() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("#a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assert.assertEquals((long)0L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testR() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("#*a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assert.assertEquals((long)0L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testS() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("a.b.c*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assert.assertEquals((long)0L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testT() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("*a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assert.assertEquals((long)0L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testU() throws Exception {
        SimpleString s1 = new SimpleString("a.b.c.d");
        SimpleString s3 = new SimpleString("*a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assert.assertEquals((long)0L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testV() throws Exception {
        SimpleString s1 = new SimpleString("a.b.d");
        SimpleString s3 = new SimpleString("a.b.#.d");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(s3));
        SimpleString s2 = new SimpleString("a.b.b.b.b.d");
        this.underTest.put(s2, (Object)s2);
        Assert.assertEquals((long)2L, (long)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testVReverse() throws Exception {
        SimpleString s1 = new SimpleString("a.b.d");
        SimpleString s3 = new SimpleString("a.b.#.d");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assert.assertTrue((boolean)a1.matches((Address)w));
        this.underTest.put(s3, (Object)s3);
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(s1));
    }

    @Test
    public void testHashNMatch() throws Exception {
        SimpleString addressABCF = new SimpleString("a.b.c.f");
        SimpleString addressACF = new SimpleString("a.c.f");
        SimpleString match = new SimpleString("a.#.f");
        this.underTest.put(addressABCF, (Object)addressABCF);
        this.underTest.put(addressACF, (Object)addressACF);
        Assert.assertEquals((long)2L, (long)this.countNonWildcardMatching(match));
    }

    @Test
    public void testEndHash() throws Exception {
        SimpleString addressAB = new SimpleString("a.b");
        SimpleString addressACF = new SimpleString("a.c.f");
        SimpleString addressABC = new SimpleString("a.b.c");
        SimpleString match = new SimpleString("a.b.#");
        this.underTest.put(addressAB, (Object)addressAB);
        this.underTest.put(addressACF, (Object)addressACF);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(match));
        this.underTest.put(addressABC, (Object)addressABC);
        Assert.assertEquals((long)2L, (long)this.countNonWildcardMatching(match));
    }

    @Test
    public void testHashEndInMap() throws Exception {
        SimpleString addressABHash = new SimpleString("a.b.#");
        SimpleString addressABC = new SimpleString("a.b.c");
        SimpleString match = new SimpleString("a.b");
        this.underTest.put(addressABHash, (Object)addressABHash);
        this.underTest.put(addressABC, (Object)addressABC);
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(match));
    }

    private int countMatchingWildcards(SimpleString plainAddress) throws Exception {
        AtomicInteger count = new AtomicInteger();
        this.underTest.visitMatchingWildcards(plainAddress, value -> count.incrementAndGet());
        return count.get();
    }

    private int countNonWildcardMatching(SimpleString canBeWildcardAddress) throws Exception {
        AtomicInteger count = new AtomicInteger();
        this.underTest.visitMatching(canBeWildcardAddress, value -> count.incrementAndGet());
        return count.get();
    }

    @Test
    public void testHashEndMatchMap() throws Exception {
        SimpleString match = new SimpleString("a.b.#");
        SimpleString addressABC = new SimpleString("a.b.c");
        SimpleString addressAB = new SimpleString("a.b");
        this.underTest.put(addressAB, (Object)addressAB);
        this.underTest.put(addressABC, (Object)addressABC);
        Assert.assertEquals((long)0L, (long)this.countMatchingWildcards(match));
        Assert.assertEquals((long)2L, (long)this.countNonWildcardMatching(match));
        this.underTest.put(match, (Object)match);
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(match));
    }

    @Test
    public void testHashAGet() throws Exception {
        SimpleString hashA = new SimpleString("#.a");
        this.underTest.put(hashA, (Object)hashA);
        SimpleString matchA = new SimpleString("a");
        SimpleString matchAB = new SimpleString("a.b");
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(matchA));
        Assert.assertEquals((long)0L, (long)this.countMatchingWildcards(matchAB));
        AddressImpl aStar = new AddressImpl(hashA);
        AddressImpl aA = new AddressImpl(matchA);
        Assert.assertTrue((boolean)aA.matches((Address)aStar));
        AddressImpl aAB = new AddressImpl(matchAB);
        Assert.assertFalse((boolean)aAB.matches((Address)aStar));
    }

    @Test
    public void testStarOne() throws Exception {
        SimpleString star = new SimpleString("*");
        this.underTest.put(star, (Object)star);
        SimpleString matchA = new SimpleString("a");
        SimpleString matchAB = new SimpleString("a.b");
        AtomicInteger count = new AtomicInteger();
        this.underTest.visitMatchingWildcards(matchA, value -> count.incrementAndGet());
        Assert.assertEquals((long)1L, (long)count.get());
        count.set(0);
        this.underTest.visitMatchingWildcards(matchAB, value -> count.incrementAndGet());
        Assert.assertEquals((long)0L, (long)count.get());
    }

    @Test
    public void testHashOne() throws Exception {
        SimpleString hash = new SimpleString("#");
        this.underTest.put(hash, (Object)hash);
        SimpleString matchA = new SimpleString("a");
        SimpleString matchAB = new SimpleString("a.b");
        SimpleString matchABC = new SimpleString("a.b.c");
        AtomicInteger count = new AtomicInteger();
        AddressMapVisitor countCollector = value -> count.incrementAndGet();
        count.set(0);
        this.underTest.visitMatchingWildcards(matchA, countCollector);
        Assert.assertEquals((long)1L, (long)count.get());
        count.set(0);
        this.underTest.visitMatchingWildcards(matchAB, countCollector);
        Assert.assertEquals((long)1L, (long)count.get());
        count.set(0);
        this.underTest.visitMatchingWildcards(matchABC, countCollector);
        Assert.assertEquals((long)1L, (long)count.get());
    }

    @Test
    public void testHashAMatch() throws Exception {
        SimpleString a = new SimpleString("a");
        this.underTest.put(a, (Object)a);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(new SimpleString("#.a")));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(new SimpleString("a")));
    }

    @Test
    public void testHashA() throws Exception {
        SimpleString hashA = new SimpleString("#.a");
        this.underTest.put(hashA, (Object)hashA);
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(new SimpleString("a")));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(new SimpleString("d.f.c.a")));
        SimpleString abcaS = new SimpleString("a.b.c.a");
        AddressImpl aHashA = new AddressImpl(hashA);
        AddressImpl aABCA = new AddressImpl(abcaS);
        Assert.assertFalse((boolean)aABCA.matches((Address)aHashA));
        Assert.assertFalse((boolean)aHashA.matches((Address)aABCA));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(abcaS));
        Assert.assertEquals((long)0L, (long)this.countMatchingWildcards(new SimpleString("a.b")));
        Assert.assertEquals((long)0L, (long)this.countMatchingWildcards(new SimpleString("a.b.c")));
        Assert.assertEquals((long)0L, (long)this.countMatchingWildcards(new SimpleString("a.b.c.a.d")));
        SimpleString AHashA = new SimpleString("a.#.a");
        this.underTest.put(AHashA, (Object)AHashA);
        Assert.assertEquals((long)2L, (long)this.countMatchingWildcards(new SimpleString("a.b.c.a")));
        Assert.assertEquals((long)0L, (long)this.countNonWildcardMatching(new SimpleString("a.b.c.a")));
        this.underTest.remove(hashA, (Object)hashA);
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(new SimpleString("a.b.c.a")));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(new SimpleString("a.a")));
    }

    @Test
    public void testAHashA() throws Exception {
        AtomicInteger count = new AtomicInteger();
        AddressMapVisitor countCollector = value -> count.incrementAndGet();
        SimpleString AHashA = new SimpleString("a.#.a");
        this.underTest.put(AHashA, (Object)AHashA);
        count.set(0);
        this.underTest.visitMatchingWildcards(new SimpleString("a.b.c.a"), countCollector);
        Assert.assertEquals((long)1L, (long)count.get());
        count.set(0);
        this.underTest.visitMatchingWildcards(new SimpleString("a.a"), countCollector);
        Assert.assertEquals((long)1L, (long)count.get());
        count.set(0);
        this.underTest.visitMatchingWildcards(new SimpleString("a"), countCollector);
        Assert.assertEquals((long)0L, (long)count.get());
    }

    @Test
    public void testStar() throws Exception {
        SimpleString star = new SimpleString("*");
        SimpleString addressA = new SimpleString("a");
        SimpleString addressAB = new SimpleString("a.b");
        this.underTest.put(star, (Object)star);
        this.underTest.put(addressAB, (Object)addressAB);
        AtomicInteger count = new AtomicInteger();
        this.underTest.visitMatchingWildcards(addressA, value -> count.incrementAndGet());
        Assert.assertEquals((long)1L, (long)count.get());
    }

    @Test
    public void testSomeAndAny() throws Exception {
        SimpleString star = new SimpleString("test.*.some.#");
        this.underTest.put(star, (Object)star);
        Assert.assertEquals((long)0L, (long)this.countNonWildcardMatching(star));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(star));
        SimpleString addressA = new SimpleString("test.1.some.la");
        this.underTest.put(addressA, (Object)addressA);
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(star));
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(star));
        Assert.assertEquals((long)2L, (long)this.countMatchingWildcards(addressA));
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(addressA));
    }

    @Test
    public void testAnyAndSome() throws Exception {
        SimpleString star = new SimpleString("test.#.some.*");
        this.underTest.put(star, (Object)star);
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(star));
        SimpleString addressA = new SimpleString("test.1.some.la");
        this.underTest.put(addressA, (Object)addressA);
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(star));
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(star));
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(addressA));
        Assert.assertEquals((long)2L, (long)this.countMatchingWildcards(addressA));
    }

    @Test
    public void testAnyAndSomeInMap() throws Exception {
        SimpleString hashHash = new SimpleString("test.#.some.#");
        this.underTest.put(hashHash, (Object)hashHash);
        SimpleString starStar = new SimpleString("test.*.some.*");
        this.underTest.put(starStar, (Object)starStar);
        SimpleString hashStar = new SimpleString("test.#.A.*");
        this.underTest.put(hashStar, (Object)hashStar);
        SimpleString oneHashStar = new SimpleString("test.1.#.T");
        this.underTest.put(oneHashStar, (Object)oneHashStar);
        Assert.assertEquals((long)2L, (long)this.countMatchingWildcards(hashHash));
        Assert.assertEquals((long)0L, (long)this.countNonWildcardMatching(hashHash));
        SimpleString reqular = new SimpleString("test.a.b.some");
        this.underTest.put(reqular, (Object)reqular);
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(hashHash));
        Assert.assertEquals((long)1L, (long)this.countNonWildcardMatching(reqular));
        Assert.assertEquals((long)2L, (long)this.countMatchingWildcards(reqular));
    }

    @Test
    public void testHashAandHashB() throws Exception {
        SimpleString hashAhash = new SimpleString("test.#.aaa.#");
        this.underTest.put(hashAhash, (Object)hashAhash);
        SimpleString hashBhash = new SimpleString("test.#.bbb.#");
        this.underTest.put(hashBhash, (Object)hashBhash);
        Assert.assertEquals((long)2L, (long)this.countMatchingWildcards(SimpleString.toSimpleString((String)"test.aaa.bbb")));
        Assert.assertEquals((long)2L, (long)this.countMatchingWildcards(SimpleString.toSimpleString((String)"test.bbb.aaa")));
        Assert.assertEquals((long)2L, (long)this.countMatchingWildcards(SimpleString.toSimpleString((String)"test.bbb.aaa.ccc")));
        Assert.assertEquals((long)2L, (long)this.countMatchingWildcards(SimpleString.toSimpleString((String)"test.aaa.bbb.ccc")));
    }

    @Test
    public void testHashNoHashNo() throws Exception {
        SimpleString hashAhash = new SimpleString("test.#.0.#.168");
        this.underTest.put(hashAhash, (Object)hashAhash);
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(SimpleString.toSimpleString((String)"test.0.168")));
    }

    @Test
    public void testHashNoHashHashNo() throws Exception {
        SimpleString v = new SimpleString("test.#.0.#.168");
        this.underTest.put(v, (Object)v);
        v = new SimpleString("test.#.0.#");
        this.underTest.put(v, (Object)v);
        v = new SimpleString("test.0.#");
        this.underTest.put(v, (Object)v);
        Assert.assertEquals((long)3L, (long)this.countMatchingWildcards(SimpleString.toSimpleString((String)"test.0.168")));
    }

    @Test
    public void testHashNoHashNoWithNMatch() throws Exception {
        for (String s : new String[]{"t.#.0.#", "t.#.1.#", "t.#.2.#", "t.#.3.#", "t.#.1.2.3", "t.0.1.2.3"}) {
            SimpleString v = new SimpleString(s);
            this.underTest.put(v, (Object)v);
        }
        Assert.assertEquals((long)6L, (long)this.countMatchingWildcards(SimpleString.toSimpleString((String)"t.0.1.2.3")));
    }

    @Test
    public void testSomeMoreHashPlacement() throws Exception {
        for (String s : new String[]{"t.#.0.#", "t.0.1.#", "t.0.1.2.#", "t.0.1.#.2.3", "t.*.#.1.2.3"}) {
            SimpleString v = new SimpleString(s);
            this.underTest.put(v, (Object)v);
        }
        Assert.assertEquals((long)5L, (long)this.countMatchingWildcards(SimpleString.toSimpleString((String)"t.0.1.2.3")));
        Assert.assertEquals((long)3L, (long)this.countMatchingWildcards(SimpleString.toSimpleString((String)"t.0.1.2.3.4")));
    }

    @Test
    public void testManyEntries() throws Exception {
        SimpleString star;
        int i;
        for (i = 0; i < 10; ++i) {
            star = new SimpleString("test." + i);
            this.underTest.put(star, (Object)star);
        }
        Assert.assertEquals((long)10L, (long)this.countNonWildcardMatching(new SimpleString("test.*")));
        Assert.assertEquals((long)10L, (long)this.countNonWildcardMatching(new SimpleString("test.#")));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(new SimpleString("test.0")));
        this.underTest.put(new SimpleString("test.#"), (Object)new SimpleString("test.#"));
        this.underTest.put(new SimpleString("test.*"), (Object)new SimpleString("test.*"));
        Assert.assertEquals((long)3L, (long)this.countMatchingWildcards(new SimpleString("test.1")));
        Assert.assertEquals((long)10L, (long)this.countNonWildcardMatching(new SimpleString("test.#")));
        Assert.assertEquals((long)10L, (long)this.countNonWildcardMatching(new SimpleString("test.*")));
        for (i = 0; i < 10; ++i) {
            star = new SimpleString("test.a." + i);
            this.underTest.put(star, (Object)star);
        }
        Assert.assertEquals((long)2L, (long)this.countMatchingWildcards(new SimpleString("test.a.0")));
        Assert.assertEquals((long)20L, (long)this.countNonWildcardMatching(new SimpleString("test.#")));
        for (i = 0; i < 10; ++i) {
            star = new SimpleString("test.b." + i);
            this.underTest.put(star, (Object)star);
        }
        Assert.assertEquals((long)10L, (long)this.countNonWildcardMatching(new SimpleString("test.b.*")));
        this.underTest.remove(new SimpleString("test.#"), (Object)new SimpleString("test.#"));
        Assert.assertEquals((long)10L, (long)this.countNonWildcardMatching(new SimpleString("test.b.*")));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(new SimpleString("test.a.0")));
        for (i = 0; i < 10; ++i) {
            star = new SimpleString("test.c." + i);
            this.underTest.put(star, (Object)star);
        }
        Assert.assertEquals((long)10L, (long)this.countNonWildcardMatching(new SimpleString("test.c.*")));
        SimpleString testStarStar = new SimpleString("test.*.*");
        Assert.assertEquals((long)30L, (long)this.countNonWildcardMatching(testStarStar));
        this.underTest.put(testStarStar, (Object)testStarStar);
        Assert.assertEquals((long)30L, (long)this.countNonWildcardMatching(testStarStar));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(testStarStar));
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(new SimpleString("test.b.c")));
    }

    @Test
    public void testReset() throws Exception {
        for (int i = 0; i < 10; ++i) {
            SimpleString star = new SimpleString("test." + i);
            this.underTest.put(star, (Object)star);
        }
        Assert.assertEquals((long)0L, (long)this.countMatchingWildcards(new SimpleString("test.*")));
        Assert.assertEquals((long)10L, (long)this.countNonWildcardMatching(new SimpleString("test.*")));
        this.underTest.reset();
        Assert.assertEquals((long)0L, (long)this.countNonWildcardMatching(new SimpleString("test.*")));
    }

    @Test
    public void testRemove() throws Exception {
        for (int i = 0; i < 10; ++i) {
            SimpleString star = new SimpleString("test." + i);
            this.underTest.put(star, (Object)star);
        }
        SimpleString test1 = new SimpleString("test.1");
        Assert.assertEquals((long)1L, (long)this.countMatchingWildcards(test1));
        this.underTest.remove(test1, (Object)test1);
        Assert.assertEquals((long)0L, (long)this.countMatchingWildcards(test1));
        Assert.assertEquals((long)9L, (long)this.countNonWildcardMatching(new SimpleString("test.*")));
        for (int i = 0; i < 10; ++i) {
            SimpleString star = new SimpleString("test." + i);
            this.underTest.remove(star, (Object)star);
        }
        Assert.assertEquals((long)0L, (long)this.countNonWildcardMatching(new SimpleString("test.*")));
    }

    @Test
    public void testMax() throws Exception {
        this.underTest.put(new SimpleString("test.#.a"), (Object)new SimpleString("test.#.a"));
        this.underTest.put(new SimpleString("test.*.a"), (Object)new SimpleString("test.*.a"));
        this.underTest.put(new SimpleString("*.a"), (Object)new SimpleString("*.a"));
        this.underTest.put(new SimpleString("#.a"), (Object)new SimpleString("#.a"));
        Assert.assertEquals((long)3L, (long)this.countMatchingWildcards(new SimpleString("test.a")));
        Assert.assertEquals((long)3L, (long)this.countMatchingWildcards(new SimpleString("test.a.a")));
    }
}

