/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.jms.jndi;

import java.net.URI;
import java.util.Map;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jndi.JNDIReferenceFactory;
import org.apache.activemq.artemis.jndi.JNDIStorable;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.uri.URISupport;
import org.junit.Assert;
import org.junit.Test;

public class ObjectFactoryTest {
    @Test(timeout=1000L)
    public void testConnectionFactory() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://0");
        String clientID = RandomUtil.randomString();
        String user = RandomUtil.randomString();
        String password = RandomUtil.randomString();
        long clientFailureCheckPeriod = RandomUtil.randomPositiveLong();
        long connectionTTL = RandomUtil.randomPositiveLong();
        long callTimeout = RandomUtil.randomPositiveLong();
        int minLargeMessageSize = RandomUtil.randomPositiveInt();
        int consumerWindowSize = RandomUtil.randomPositiveInt();
        int consumerMaxRate = RandomUtil.randomPositiveInt();
        int confirmationWindowSize = RandomUtil.randomPositiveInt();
        int producerMaxRate = RandomUtil.randomPositiveInt();
        boolean blockOnAcknowledge = RandomUtil.randomBoolean();
        boolean blockOnDurableSend = RandomUtil.randomBoolean();
        boolean blockOnNonDurableSend = RandomUtil.randomBoolean();
        boolean autoGroup = RandomUtil.randomBoolean();
        boolean preAcknowledge = RandomUtil.randomBoolean();
        String loadBalancingPolicyClassName = RandomUtil.randomString();
        boolean useGlobalPools = RandomUtil.randomBoolean();
        int scheduledThreadPoolMaxSize = RandomUtil.randomPositiveInt();
        int threadPoolMaxSize = RandomUtil.randomPositiveInt();
        long retryInterval = RandomUtil.randomPositiveLong();
        double retryIntervalMultiplier = RandomUtil.randomDouble();
        int reconnectAttempts = RandomUtil.randomPositiveInt();
        factory.setClientID(clientID);
        factory.setUser(user);
        factory.setPassword(password);
        factory.setClientFailureCheckPeriod(clientFailureCheckPeriod);
        factory.setConnectionTTL(connectionTTL);
        factory.setCallTimeout(callTimeout);
        factory.setMinLargeMessageSize(minLargeMessageSize);
        factory.setConsumerWindowSize(consumerWindowSize);
        factory.setConsumerMaxRate(consumerMaxRate);
        factory.setConfirmationWindowSize(confirmationWindowSize);
        factory.setProducerMaxRate(producerMaxRate);
        factory.setBlockOnAcknowledge(blockOnAcknowledge);
        factory.setBlockOnDurableSend(blockOnDurableSend);
        factory.setBlockOnNonDurableSend(blockOnNonDurableSend);
        factory.setAutoGroup(autoGroup);
        factory.setPreAcknowledge(preAcknowledge);
        factory.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
        factory.setUseGlobalPools(useGlobalPools);
        factory.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
        factory.setThreadPoolMaxSize(threadPoolMaxSize);
        factory.setRetryInterval(retryInterval);
        factory.setRetryIntervalMultiplier(retryIntervalMultiplier);
        factory.setReconnectAttempts(reconnectAttempts);
        Reference ref = JNDIReferenceFactory.createReference((String)factory.getClass().getName(), (JNDIStorable)factory);
        JNDIReferenceFactory refFactory = new JNDIReferenceFactory();
        ActiveMQConnectionFactory temp = (ActiveMQConnectionFactory)refFactory.getObjectInstance((Object)ref, null, null, null);
        Assert.assertEquals((Object)clientID, (Object)temp.getClientID());
        Assert.assertEquals((Object)user, (Object)temp.getUser());
        Assert.assertEquals((Object)password, (Object)temp.getPassword());
        Assert.assertEquals((long)clientFailureCheckPeriod, (long)temp.getClientFailureCheckPeriod());
        Assert.assertEquals((long)connectionTTL, (long)temp.getConnectionTTL());
        Assert.assertEquals((long)callTimeout, (long)temp.getCallTimeout());
        Assert.assertEquals((long)minLargeMessageSize, (long)temp.getMinLargeMessageSize());
        Assert.assertEquals((long)consumerWindowSize, (long)temp.getConsumerWindowSize());
        Assert.assertEquals((long)consumerMaxRate, (long)temp.getConsumerMaxRate());
        Assert.assertEquals((long)confirmationWindowSize, (long)temp.getConfirmationWindowSize());
        Assert.assertEquals((long)producerMaxRate, (long)temp.getProducerMaxRate());
        Assert.assertEquals((Object)blockOnAcknowledge, (Object)temp.isBlockOnAcknowledge());
        Assert.assertEquals((Object)blockOnDurableSend, (Object)temp.isBlockOnDurableSend());
        Assert.assertEquals((Object)blockOnNonDurableSend, (Object)temp.isBlockOnNonDurableSend());
        Assert.assertEquals((Object)autoGroup, (Object)temp.isAutoGroup());
        Assert.assertEquals((Object)preAcknowledge, (Object)temp.isPreAcknowledge());
        Assert.assertEquals((Object)loadBalancingPolicyClassName, (Object)temp.getConnectionLoadBalancingPolicyClassName());
        Assert.assertEquals((Object)useGlobalPools, (Object)temp.isUseGlobalPools());
        Assert.assertEquals((long)scheduledThreadPoolMaxSize, (long)temp.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)threadPoolMaxSize, (long)temp.getThreadPoolMaxSize());
        Assert.assertEquals((long)retryInterval, (long)temp.getRetryInterval());
        Assert.assertEquals((double)retryIntervalMultiplier, (double)temp.getRetryIntervalMultiplier(), (double)1.0E-4);
        Assert.assertEquals((long)reconnectAttempts, (long)temp.getReconnectAttempts());
    }

    @Test(timeout=1000L)
    public void testDestination() throws Exception {
        ActiveMQDestination dest = (ActiveMQDestination)ActiveMQJMSClient.createQueue((String)RandomUtil.randomString());
        Reference ref = JNDIReferenceFactory.createReference((String)dest.getClass().getName(), (JNDIStorable)dest);
        JNDIReferenceFactory refFactory = new JNDIReferenceFactory();
        ActiveMQDestination temp = (ActiveMQDestination)refFactory.getObjectInstance((Object)ref, null, null, null);
        Assert.assertEquals((Object)dest.getAddress(), (Object)temp.getAddress());
    }

    @Test
    public void testJndiSslParameters() throws Exception {
        Reference reference = new Reference(ActiveMQConnectionFactory.class.getName(), JNDIReferenceFactory.class.getName(), null);
        reference.add(new StringRefAddr("brokerURL", "(tcp://localhost:61616,tcp://localhost:5545,tcp://localhost:5555)?sslEnabled=false&trustStorePath=nopath"));
        reference.add(new StringRefAddr("sslEnabled", "true"));
        reference.add(new StringRefAddr("trustStorePath", "/path/to/trustStore"));
        reference.add(new StringRefAddr("trustStorePassword", "trustStorePassword"));
        reference.add(new StringRefAddr("keyStorePath", "/path/to/keyStore"));
        reference.add(new StringRefAddr("keyStorePassword", "keyStorePassword"));
        reference.add(new StringRefAddr("doesnotexist", "somevalue"));
        JNDIReferenceFactory referenceFactory = new JNDIReferenceFactory();
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)referenceFactory.getObjectInstance((Object)reference, null, null, null);
        URI uri = cf.toURI();
        Map params = URISupport.parseParameters((URI)uri);
        Assert.assertEquals((Object)"true", params.get("sslEnabled"));
        Assert.assertEquals((Object)"/path/to/trustStore", params.get("trustStorePath"));
        Assert.assertEquals((Object)"trustStorePassword", params.get("trustStorePassword"));
        Assert.assertEquals((Object)"/path/to/keyStore", params.get("keyStorePath"));
        Assert.assertEquals((Object)"keyStorePassword", params.get("keyStorePassword"));
        Assert.assertNull(params.get("doesnotexist"));
    }
}

