/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jgroups.Address;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Owner
implements Streamable,
Comparable<Owner> {
    protected Address address;
    protected long thread_id;

    public Owner() {
    }

    public Owner(Address address, long thread_id) {
        this.address = address;
        this.thread_id = thread_id;
    }

    public Address getAddress() {
        return this.address;
    }

    public long getThreadId() {
        return this.thread_id;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        Util.writeAddress(this.address, out);
        Bits.writeLong(this.thread_id, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.address = Util.readAddress(in);
        this.thread_id = Bits.readLong(in);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Owner other = (Owner)obj;
        return Objects.equals(this.address, other.address) && this.thread_id == other.thread_id;
    }

    public int hashCode() {
        return (int)((long)this.address.hashCode() + this.thread_id);
    }

    @Override
    public int compareTo(Owner o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        return this.thread_id < o.thread_id ? -1 : (this.thread_id > o.thread_id ? 1 : (o.address == null ? 1 : this.address.compareTo(o.address)));
    }

    public String toString() {
        return this.thread_id < 0L ? this.address.toString() : this.address + "::" + this.thread_id;
    }
}

