/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.session.DistributableSessionManagementConfiguration;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.extension.clustering.web.AffinityServiceNameProvider;
import org.wildfly.extension.clustering.web.SessionGranularity;
import org.wildfly.extension.clustering.web.SessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.SessionMarshallerFactory;
import org.wildfly.extension.clustering.web.routing.RouteLocatorServiceConfiguratorFactory;

public abstract class SessionManagementServiceConfigurator<C extends DistributableSessionManagementConfiguration<DeploymentUnit>>
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
DistributableSessionManagementConfiguration<DeploymentUnit>,
Supplier<DistributableSessionManagementProvider<C>> {
    private volatile SessionGranularity granularity;
    private volatile SessionMarshallerFactory marshallerFactory;
    private volatile SupplierDependency<RouteLocatorServiceConfiguratorFactory<C>> factory;

    SessionManagementServiceConfigurator(PathAddress address) {
        super((Capability)SessionManagementResourceDefinition.Capability.SESSION_MANAGEMENT_PROVIDER, address);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.granularity = SessionGranularity.valueOf(SessionManagementResourceDefinition.Attribute.GRANULARITY.resolveModelAttribute((ExpressionResolver)context, model).asString());
        this.marshallerFactory = SessionMarshallerFactory.valueOf(SessionManagementResourceDefinition.Attribute.MARSHALLER.resolveModelAttribute((ExpressionResolver)context, model).asString());
        this.factory = new ServiceSupplierDependency((ServiceNameProvider)new AffinityServiceNameProvider(context.getCurrentAddress()));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer provider = this.factory.register(builder).provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(provider, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
        return this.granularity.getAttributePersistenceStrategy();
    }

    public Function<DeploymentUnit, ByteBufferMarshaller> getMarshallerFactory() {
        return this.marshallerFactory;
    }

    public RouteLocatorServiceConfiguratorFactory<C> getRouteLocatorServiceConfiguratorFactory() {
        return (RouteLocatorServiceConfiguratorFactory)this.factory.get();
    }
}

