/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.processors;

import jakarta.ws.rs.ext.ParamConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;

public abstract class AbstractCollectionProcessor<T> {
    protected String paramName;
    protected Type type;
    protected Annotation[] annotations;
    protected ClientConfiguration config;

    public AbstractCollectionProcessor(String paramName) {
        this.paramName = paramName;
    }

    public AbstractCollectionProcessor(String paramName, Type type, Annotation[] annotations, ClientConfiguration config) {
        this.paramName = paramName;
        this.type = type;
        this.annotations = annotations;
        this.config = config;
    }

    protected abstract T apply(T var1, Object ... var2);

    public T buildIt(T target, Object object) {
        if (object == null) {
            return target;
        }
        if (object instanceof Collection) {
            if (this.annotations != null && this.type != null) {
                ParamConverter paramConverter = this.config.getParamConverter(object.getClass(), this.type, this.annotations);
                if (paramConverter != null) {
                    object = paramConverter.toString(object);
                    target = this.apply(target, object);
                } else {
                    target = this.apply(target, ((Collection)object).toArray());
                }
            }
        } else if (object.getClass().isArray()) {
            ParamConverter paramConverter = this.config.getParamConverter(object.getClass(), this.type, this.annotations);
            if (paramConverter != null) {
                object = paramConverter.toString(object);
                target = this.apply(target, object);
            } else {
                Object[] arr = AbstractCollectionProcessor.convertToObjectsArray(object);
                target = this.apply(target, arr);
            }
        } else {
            target = this.apply(target, object);
        }
        return target;
    }

    private static Object[] convertToObjectsArray(Object array) {
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        int length = Array.getLength(array);
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            objects[i] = Array.get(array, i);
        }
        return objects;
    }
}

