/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationUtils;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusterLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.CustomStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.infinispan.util.logging.Log;

public class PersistenceConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<PersistenceConfiguration> {
    private final List<StoreConfigurationBuilder<?, ?>> stores = new ArrayList(2);
    private final AttributeSet attributes = PersistenceConfiguration.attributeDefinitionSet();

    protected PersistenceConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public PersistenceConfigurationBuilder passivation(boolean b) {
        this.attributes.attribute(PersistenceConfiguration.PASSIVATION).set((Object)b);
        return this;
    }

    public PersistenceConfigurationBuilder availabilityInterval(int interval) {
        this.attributes.attribute(PersistenceConfiguration.AVAILABILITY_INTERVAL).set((Object)interval);
        return this;
    }

    public PersistenceConfigurationBuilder connectionAttempts(int attempts) {
        this.attributes.attribute(PersistenceConfiguration.CONNECTION_ATTEMPTS).set((Object)attempts);
        return this;
    }

    public PersistenceConfigurationBuilder connectionInterval(int interval) {
        this.attributes.attribute(PersistenceConfiguration.CONNECTION_INTERVAL).set((Object)interval);
        return this;
    }

    boolean passivation() {
        return (Boolean)this.attributes.attribute(PersistenceConfiguration.PASSIVATION).get();
    }

    public <T extends StoreConfigurationBuilder<?, ?>> T addStore(Class<T> klass) {
        T builder = this.getBuilderFromClass(klass);
        this.stores.add((StoreConfigurationBuilder<?, ?>)builder);
        return builder;
    }

    private <T extends StoreConfigurationBuilder<?, ?>> T getBuilderFromClass(Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(PersistenceConfigurationBuilder.class);
            return (T)((StoreConfigurationBuilder)constructor.newInstance(this));
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate loader configuration builder '" + klass.getName() + "'", (Throwable)e);
        }
    }

    public StoreConfigurationBuilder<?, ?> addStore(StoreConfigurationBuilder<?, ?> builder) {
        this.stores.add(builder);
        return builder;
    }

    @Deprecated
    public ClusterLoaderConfigurationBuilder addClusterLoader() {
        ClusterLoaderConfigurationBuilder builder = new ClusterLoaderConfigurationBuilder(this);
        this.stores.add(builder);
        return builder;
    }

    @Deprecated
    public SingleFileStoreConfigurationBuilder addSingleFileStore() {
        SingleFileStoreConfigurationBuilder builder = new SingleFileStoreConfigurationBuilder(this);
        this.stores.add(builder);
        return builder;
    }

    public SoftIndexFileStoreConfigurationBuilder addSoftIndexFileStore() {
        SoftIndexFileStoreConfigurationBuilder builder = new SoftIndexFileStoreConfigurationBuilder(this);
        this.stores.add(builder);
        return builder;
    }

    public PersistenceConfigurationBuilder clearStores() {
        this.stores.clear();
        return this;
    }

    public void validate() {
        boolean isLocalCache = this.builder.clustering().create().cacheMode().equals((Object)CacheMode.LOCAL);
        int numFetchPersistentState = 0;
        int numPreload = 0;
        for (StoreConfigurationBuilder<?, ?> b : this.stores) {
            b.validate();
            StoreConfiguration storeConfiguration = (StoreConfiguration)b.create();
            if (storeConfiguration.shared()) {
                if (b.persistence().passivation()) {
                    throw Log.CONFIG.passivationStoreCannotBeShared(storeConfiguration.getClass().getSimpleName());
                }
                if (storeConfiguration.purgeOnStartup()) {
                    throw Log.CONFIG.sharedStoreShouldNotBePurged(storeConfiguration.getClass().getSimpleName());
                }
            } else if (storeConfiguration.transactional() && !isLocalCache) {
                throw Log.CONFIG.clusteredTransactionalStoreMustBeShared(storeConfiguration.getClass().getSimpleName());
            }
            if (storeConfiguration.async().enabled() && storeConfiguration.transactional()) {
                throw Log.CONFIG.transactionalStoreCannotBeAsync(storeConfiguration.getClass().getSimpleName());
            }
            if (storeConfiguration.fetchPersistentState()) {
                ++numFetchPersistentState;
            }
            if (!storeConfiguration.preload()) continue;
            ++numPreload;
        }
        if (numFetchPersistentState > 1) {
            throw Log.CONFIG.onlyOneFetchPersistentStoreAllowed();
        }
        if (numPreload > 1) {
            throw Log.CONFIG.onlyOnePreloadStoreAllowed();
        }
        if (!this.stores.isEmpty()) {
            boolean reaperEnabled = this.builder.expiration().reaperEnabled();
            long wakeupInterval = this.builder.expiration().wakeupInterval();
            if (!reaperEnabled || wakeupInterval < 0L) {
                this.builder.expiration().enableReaper();
                if (wakeupInterval < 0L) {
                    Log.CONFIG.debug("Store present and expiration reaper wakeup was less than 0 - explicitly enabling and setting wakeup interval to 1 minute.");
                    this.builder.expiration().wakeUpInterval(1L, TimeUnit.MINUTES);
                } else {
                    Log.CONFIG.debug("Store present however expiration reaper was not enabled - explicitly enabling.");
                }
            }
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        for (StoreConfigurationBuilder<?, ?> b : this.stores) {
            b.validate(globalConfig);
        }
    }

    public PersistenceConfiguration create() {
        ArrayList<StoreConfiguration> stores = new ArrayList<StoreConfiguration>(this.stores.size());
        for (StoreConfigurationBuilder<?, ?> loader : this.stores) {
            stores.add((StoreConfiguration)loader.create());
        }
        return new PersistenceConfiguration(this.attributes.protect(), stores);
    }

    public PersistenceConfigurationBuilder read(PersistenceConfiguration template) {
        this.attributes.read(template.attributes());
        this.clearStores();
        for (StoreConfiguration c : template.stores()) {
            Class<? extends StoreConfigurationBuilder<?, ?>> builderClass = this.getBuilderClass(c);
            StoreConfigurationBuilder<?, ?> builder = this.getBuilderFromClass(builderClass);
            this.stores.add((StoreConfigurationBuilder)builder.read(c));
        }
        return this;
    }

    private Class<? extends StoreConfigurationBuilder<?, ?>> getBuilderClass(StoreConfiguration c) {
        Class<CustomStoreConfigurationBuilder> builderClass = ConfigurationUtils.builderForNonStrict((Object)c);
        if (builderClass == null) {
            builderClass = CustomStoreConfigurationBuilder.class;
        }
        return builderClass;
    }

    public List<StoreConfigurationBuilder<?, ?>> stores() {
        return this.stores;
    }

    public String toString() {
        return "PersistenceConfigurationBuilder [stores=" + this.stores + ", attributes=" + this.attributes + "]";
    }
}

