/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OutboundTransferTask {
    private static final Log log = LogFactory.getLog(OutboundTransferTask.class);
    private final Consumer<Collection<StateChunk>> onChunkReplicated;
    private final int topologyId;
    private final Address destination;
    private final IntSet segments;
    private final int chunkSize;
    private final KeyPartitioner keyPartitioner;
    private final RpcManager rpcManager;
    private final CommandsFactory commandsFactory;
    private final long timeout;
    private final String cacheName;
    private final boolean applyState;
    private final boolean pushTransfer;
    private final RpcOptions rpcOptions;
    private volatile boolean cancelled;

    public OutboundTransferTask(Address destination, IntSet segments, int segmentCount, int chunkSize, int topologyId, KeyPartitioner keyPartitioner, Consumer<Collection<StateChunk>> onChunkReplicated, RpcManager rpcManager, CommandsFactory commandsFactory, long timeout, String cacheName, boolean applyState, boolean pushTransfer) {
        if (segments == null || segments.isEmpty()) {
            throw new IllegalArgumentException("Segments must not be null or empty");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Destination address cannot be null");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be greater than 0");
        }
        this.onChunkReplicated = onChunkReplicated;
        this.destination = destination;
        this.segments = IntSets.concurrentCopyFrom((IntSet)segments, (int)segmentCount);
        this.chunkSize = chunkSize;
        this.topologyId = topologyId;
        this.keyPartitioner = keyPartitioner;
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.timeout = timeout;
        this.cacheName = cacheName;
        this.applyState = applyState;
        this.pushTransfer = pushTransfer;
        this.rpcOptions = new RpcOptions(DeliverOrder.NONE, timeout, TimeUnit.MILLISECONDS);
    }

    public Address getDestination() {
        return this.destination;
    }

    public IntSet getSegments() {
        return this.segments;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public CompletionStage<Void> execute(Flowable<InternalCacheEntry<Object, Object>> entries) {
        final CompletableFuture<Void> taskFuture = new CompletableFuture<Void>();
        try {
            final AtomicReference batchRef = new AtomicReference(Collections.emptyList());
            entries.buffer(this.chunkSize).takeUntil(batch -> this.cancelled).concatMapCompletable(batch -> {
                List previousBatch = batchRef.getAndSet(batch);
                if (previousBatch.isEmpty()) {
                    return Completable.complete();
                }
                return Completable.fromCompletionStage(this.sendEntries(previousBatch, false));
            }, 1).subscribe(new CompletableObserver(){

                public void onSubscribe(Disposable d) {
                }

                public void onComplete() {
                    List previousBatch = (List)batchRef.get();
                    OutboundTransferTask.this.sendEntries(previousBatch, true).whenComplete((ignored, throwable) -> {
                        if (throwable == null) {
                            taskFuture.complete(null);
                        } else {
                            taskFuture.completeExceptionally((Throwable)throwable);
                        }
                    });
                }

                public void onError(Throwable e) {
                    taskFuture.completeExceptionally(e);
                }
            });
        }
        catch (Throwable t) {
            taskFuture.completeExceptionally(t);
        }
        return taskFuture;
    }

    private CompletionStage<Void> sendEntries(List<InternalCacheEntry<Object, Object>> entries, boolean isLast) {
        HashMap<Integer, StateChunk> chunks = new HashMap<Integer, StateChunk>();
        for (InternalCacheEntry<Object, Object> ice : entries) {
            int segmentId = this.keyPartitioner.getSegment(ice.getKey());
            if (!this.segments.contains(segmentId)) continue;
            StateChunk chunk = chunks.computeIfAbsent(segmentId, segment -> new StateChunk((int)segment, new ArrayList(), isLast));
            chunk.getCacheEntries().add(ice);
        }
        if (isLast) {
            PrimitiveIterator.OfInt iter = this.segments.iterator();
            while (iter.hasNext()) {
                int segmentId = iter.nextInt();
                chunks.computeIfAbsent(segmentId, segment -> new StateChunk((int)segment, (Collection<InternalCacheEntry<?, ?>>)Collections.emptyList(), true));
            }
        }
        if (chunks.isEmpty()) {
            return CompletableFutures.completedNull();
        }
        if (log.isTraceEnabled()) {
            if (isLast) {
                log.tracef("Sending last chunk to node %s containing %d cache entries from segments %s", this.destination, entries.size(), this.segments);
            } else {
                log.tracef("Sending to node %s %d cache entries from segments %s", this.destination, entries.size(), chunks.keySet());
            }
        }
        StateResponseCommand cmd = this.commandsFactory.buildStateResponseCommand(this.topologyId, chunks.values(), this.applyState, this.pushTransfer);
        try {
            return this.rpcManager.invokeCommand(this.destination, (ReplicableCommand)cmd, SingleResponseCollector.validOnly(), this.rpcOptions).handle((response, throwable) -> {
                if (throwable == null) {
                    this.onChunkReplicated.accept(chunks.values());
                    return null;
                }
                this.logSendException((Throwable)throwable);
                this.cancel();
                return null;
            });
        }
        catch (IllegalLifecycleStateException e) {
            this.cancel();
        }
        catch (Exception e) {
            this.logSendException(e);
            this.cancel();
        }
        return CompletableFutures.completedNull();
    }

    private void logSendException(Throwable throwable) {
        Throwable t = CompletableFutures.extractException(throwable);
        if (t instanceof SuspectException) {
            log.debugf("Node %s left cache %s while we were sending state to it, cancelling transfer.", this.destination, this.cacheName);
        } else if (this.isCancelled()) {
            log.debugf("Stopping cancelled transfer to node %s, segments %s", this.destination, this.segments);
        } else {
            log.errorf(t, "Failed to send entries to node %s: %s", this.destination, t.getMessage());
        }
    }

    void cancelSegments(IntSet cancelledSegments) {
        if (this.segments.removeAll(cancelledSegments)) {
            if (log.isTraceEnabled()) {
                log.tracef("Cancelling outbound transfer to node %s, segments %s (remaining segments %s)", this.destination, cancelledSegments, this.segments);
            }
            if (this.segments.isEmpty()) {
                this.cancel();
            }
        }
    }

    public void cancel() {
        if (!this.cancelled) {
            log.debugf("Cancelling outbound transfer to node %s, segments %s", this.destination, this.segments);
            this.cancelled = true;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String toString() {
        return "OutboundTransferTask{topologyId=" + this.topologyId + ", destination=" + this.destination + ", segments=" + this.segments + ", chunkSize=" + this.chunkSize + ", timeout=" + this.timeout + ", cacheName='" + this.cacheName + '\'' + '}';
    }
}

