/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.context.Flag;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.stats.Stats;
import org.infinispan.util.logging.Log;

@MBean(objectName="Statistics", description="General statistics such as timings, hit/miss ratio, etc.")
@Scope(value=Scopes.NAMED_CACHE)
public final class StatsCollector
implements Stats,
JmxStatisticsExposer {
    public static final IntSet SEGMENT_0 = IntSets.immutableSet((int)0);
    private final LongAdder hitTimes = new LongAdder();
    private final LongAdder missTimes = new LongAdder();
    private final LongAdder storeTimes = new LongAdder();
    private final LongAdder removeTimes = new LongAdder();
    private final LongAdder hits = new LongAdder();
    private final LongAdder misses = new LongAdder();
    private final LongAdder stores = new LongAdder();
    private final LongAdder evictions = new LongAdder();
    private final AtomicLong startNanoseconds = new AtomicLong(0L);
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    private final LongAdder removeHits = new LongAdder();
    private final LongAdder removeMisses = new LongAdder();
    @Inject
    ComponentRef<AdvancedCache<?, ?>> cache;
    @Inject
    TimeService timeService;
    @Inject
    ComponentRef<InternalDataContainer<?, ?>> dataContainer;
    @Inject
    OffHeapMemoryAllocator allocator;
    @Inject
    Configuration configuration;
    @Inject
    ComponentRegistry componentRegistry;
    @Inject
    ComponentRef<PersistenceManager> persistenceManager;
    private boolean statisticsEnabled = false;

    @Start
    public void start() {
        this.statisticsEnabled = this.configuration.statistics().enabled();
    }

    @Override
    @ManagedAttribute(description="Number of cache attribute hits", displayName="Number of cache hits", measurementType=MeasurementType.TRENDSUP)
    public long getHits() {
        return this.hits.sum();
    }

    @Override
    @ManagedAttribute(description="Number of cache attribute misses", displayName="Number of cache misses", measurementType=MeasurementType.TRENDSUP)
    public long getMisses() {
        return this.misses.sum();
    }

    @Override
    @ManagedAttribute(description="Number of cache removal hits", displayName="Number of cache removal hits", measurementType=MeasurementType.TRENDSUP)
    public long getRemoveHits() {
        return this.removeHits.sum();
    }

    @Override
    @ManagedAttribute(description="Number of cache removals where keys were not found", displayName="Number of cache removal misses", measurementType=MeasurementType.TRENDSUP)
    public long getRemoveMisses() {
        return this.removeMisses.sum();
    }

    @Override
    @ManagedAttribute(description="Number of cache attribute put operations", displayName="Number of cache puts", measurementType=MeasurementType.TRENDSUP)
    public long getStores() {
        return this.stores.sum();
    }

    @Override
    public long getRetrievals() {
        return this.hits.longValue() + this.misses.longValue();
    }

    @Override
    @ManagedAttribute(description="Number of cache eviction operations", displayName="Number of cache evictions", measurementType=MeasurementType.TRENDSUP)
    public long getEvictions() {
        return this.evictions.sum();
    }

    @ManagedAttribute(description="Percentage hit/(hit+miss) ratio for the cache", displayName="Hit ratio", units=Units.PERCENTAGE)
    public double getHitRatio() {
        long hitsL = this.hits.sum();
        double total = hitsL + this.misses.sum();
        if (total <= 0.0) {
            return 0.0;
        }
        return (double)hitsL / total;
    }

    @ManagedAttribute(description="Read/writes ratio for the cache", displayName="Read/write ratio", units=Units.PERCENTAGE)
    public double getReadWriteRatio() {
        long sum = this.stores.sum();
        if (sum == 0L) {
            return 0.0;
        }
        return (double)(this.hits.sum() + this.misses.sum()) / (double)sum;
    }

    @Override
    @ManagedAttribute(description="Average number of milliseconds for a read operation on the cache", displayName="Average read time", units=Units.MILLISECONDS)
    public long getAverageReadTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.getAverageReadTimeNanos());
    }

    @Override
    @ManagedAttribute(description="Average number of nanoseconds for a read operation on the cache", displayName="Average read time (ns)", units=Units.NANOSECONDS)
    public long getAverageReadTimeNanos() {
        long total = this.hits.sum() + this.misses.sum();
        if (total == 0L) {
            return 0L;
        }
        return (this.hitTimes.sum() + this.missTimes.sum()) / total;
    }

    @Override
    @ManagedAttribute(description="Average number of milliseconds for a write operation in the cache", displayName="Average write time", units=Units.MILLISECONDS)
    public long getAverageWriteTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.getAverageWriteTimeNanos());
    }

    @Override
    @ManagedAttribute(description="Average number of nanoseconds for a write operation in the cache", displayName="Average write time (ns)", units=Units.NANOSECONDS)
    public long getAverageWriteTimeNanos() {
        long sum = this.stores.sum();
        if (sum == 0L) {
            return 0L;
        }
        return this.storeTimes.sum() / sum;
    }

    @Override
    @ManagedAttribute(description="Average number of milliseconds for a remove operation in the cache", displayName="Average remove time", units=Units.MILLISECONDS)
    public long getAverageRemoveTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.getAverageWriteTimeNanos());
    }

    @Override
    @ManagedAttribute(description="Average number of nanoseconds for a remove operation in the cache", displayName="Average remove time (ns)", units=Units.NANOSECONDS)
    public long getAverageRemoveTimeNanos() {
        long removes = this.getRemoveHits();
        if (removes == 0L) {
            return 0L;
        }
        return this.removeTimes.sum() / removes;
    }

    @Override
    @ManagedAttribute(description="Required minimum number of nodes to hold current cache data", displayName="Required minimum number of nodes")
    public int getRequiredMinimumNumberOfNodes() {
        return CacheMgmtInterceptor.calculateRequiredMinimumNumberOfNodes(this.cache.wired(), this.componentRegistry);
    }

    @Override
    public void reset() {
        this.resetStatistics();
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", writable=true)
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @Deprecated
    @ManagedAttribute(description="Number of entries in the cache including passivated entries", displayName="Number of current cache entries")
    public int getNumberOfEntries() {
        return this.cache.wired().withFlags(Flag.CACHE_MODE_LOCAL).size();
    }

    @Override
    @Deprecated
    @ManagedAttribute(description="Number of entries currently in-memory excluding expired entries", displayName="Number of in-memory cache entries")
    public int getCurrentNumberOfEntriesInMemory() {
        return this.dataContainer.running().size();
    }

    @Override
    @ManagedAttribute(description="Number of seconds since cache started", displayName="Seconds since cache started", units=Units.SECONDS, measurementType=MeasurementType.TRENDSUP)
    public long getTimeSinceStart() {
        return this.timeService.timeDuration(this.startNanoseconds.get(), TimeUnit.SECONDS);
    }

    @Override
    @ManagedAttribute(description="Number of seconds since the cache statistics were last reset", displayName="Seconds since cache statistics were reset", units=Units.SECONDS)
    public long getTimeSinceReset() {
        return this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
    }

    @Override
    @ManagedAttribute(description="Approximate current number of entries in the cache, including persisted and expired entries.", displayName="Approximate number of entries")
    public long getApproximateEntries() {
        return this.dataContainer.running().sizeIncludingExpired();
    }

    @Override
    @ManagedAttribute(description="Approximate current number of entries in memory, including expired entries.", displayName="Approximate number of cache entries in memory")
    public long getApproximateEntriesInMemory() {
        return this.dataContainer.running().sizeIncludingExpired();
    }

    @Override
    @ManagedAttribute(description="Approximate current number of entries in the cache, including persisted and expired entries.", displayName="Approximate number of entries")
    public long getApproximateEntriesUnique() {
        return this.getApproximateEntries();
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return this.getNumberOfEntries();
    }

    @Override
    @Deprecated
    public long getTotalNumberOfEntries() {
        return this.stores.longValue();
    }

    @Override
    @ManagedAttribute(description="Amount of memory in bytes allocated for use in eviction for data in the cache", displayName="Memory used by data in the cache")
    public long getDataMemoryUsed() {
        if (this.configuration.memory().isEvictionEnabled() && this.configuration.memory().evictionType() == EvictionType.MEMORY) {
            return this.dataContainer.running().evictionSize();
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Amount off-heap memory used by this cache (bytes)", displayName="Off-Heap memory used")
    public long getOffHeapMemoryUsed() {
        return this.allocator.getAllocatedAmount();
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset Statistics (Statistics)")
    public void resetStatistics() {
        this.hits.reset();
        this.misses.reset();
        this.stores.reset();
        this.evictions.reset();
        this.hitTimes.reset();
        this.missTimes.reset();
        this.storeTimes.reset();
        this.removeHits.reset();
        this.removeTimes.reset();
        this.removeMisses.reset();
        this.resetNanoseconds.set(this.timeService.time());
    }

    public void recordMisses(int misses, long time) {
        this.misses.add(misses);
        this.missTimes.add(time);
    }

    public void recordHits(int hits, long time) {
        this.hits.add(hits);
        this.hitTimes.add(time);
    }

    public void recordEviction() {
        this.evictions.increment();
    }

    public void recordEvictions(int evicted) {
        this.evictions.add(evicted);
    }

    public void recordStores(int stores, long time) {
        this.stores.add(stores);
        this.storeTimes.add(time);
    }

    public void recordRemoveHits(int removes, long time) {
        this.removeHits.add(removes);
        this.removeTimes.add(time);
    }

    public void recordRemoveMisses(int removes) {
        this.removeMisses.add(removes);
    }

    public Json toJson() {
        throw new UnsupportedOperationException();
    }

    @DefaultFactoryFor(classes={StatsCollector.class})
    @SurvivesRestarts
    public static class Factory
    extends AbstractNamedCacheComponentFactory
    implements AutoInstantiableFactory {
        @Override
        public Object construct(String componentName) {
            if (componentName.equals(StatsCollector.class.getName())) {
                if (this.configuration.simpleCache()) {
                    return new StatsCollector();
                }
                return null;
            }
            throw Log.CONTAINER.factoryCannotConstructComponent(componentName);
        }
    }
}

