/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;

public class XSiteStateTransferStartSendCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 104;
    private String siteName;
    private int topologyId;

    public XSiteStateTransferStartSendCommand() {
        super(null);
    }

    public XSiteStateTransferStartSendCommand(ByteString cacheName) {
        this(cacheName, null, -1);
    }

    public XSiteStateTransferStartSendCommand(ByteString cacheName, String siteName, int topologyId) {
        super(cacheName);
        this.siteName = siteName;
        this.topologyId = topologyId;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        this.invokeLocal(registry.getXSiteStateTransferManager().running().getStateProvider());
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 104;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeUTF(this.siteName);
        output.writeInt(this.topologyId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.siteName = input.readUTF();
        this.topologyId = input.readInt();
    }

    @Override
    public String toString() {
        return "XSiteStateTransferStartSendCommand{siteName='" + this.siteName + '\'' + ", topologyId=" + this.topologyId + ", cacheName=" + this.cacheName + '}';
    }

    public void invokeLocal(XSiteStateProvider provider) {
        provider.startStateTransfer(this.siteName, this.getOrigin(), this.topologyId);
    }
}

