/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox;

import java.io.IOException;
import org.bouncycastle.gpg.keybox.BlobType;
import org.bouncycastle.gpg.keybox.BlobVerifier;
import org.bouncycastle.gpg.keybox.CertificateBlob;
import org.bouncycastle.gpg.keybox.FirstBlob;
import org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import org.bouncycastle.gpg.keybox.PublicKeyRingBlob;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Strings;

public class Blob {
    protected static final byte[] magicBytes = Strings.toByteArray((String)"KBXf");
    protected final int base;
    protected final long length;
    protected final BlobType type;
    protected final int version;

    protected Blob(int n, long l, BlobType blobType, int n2) {
        this.base = n;
        this.length = l;
        this.type = blobType;
        this.version = n2;
    }

    static Blob getInstance(Object object, KeyFingerPrintCalculator keyFingerPrintCalculator, BlobVerifier blobVerifier) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("Cannot take get instance of null");
        }
        KeyBoxByteBuffer keyBoxByteBuffer = KeyBoxByteBuffer.wrap(object);
        if (!keyBoxByteBuffer.hasRemaining()) {
            return null;
        }
        int n = keyBoxByteBuffer.position();
        long l = keyBoxByteBuffer.u32();
        BlobType blobType = BlobType.fromByte(keyBoxByteBuffer.u8());
        int n2 = keyBoxByteBuffer.u8();
        switch (blobType) {
            case EMPTY_BLOB: {
                break;
            }
            case FIRST_BLOB: {
                return FirstBlob.parseContent(n, l, blobType, n2, keyBoxByteBuffer);
            }
            case X509_BLOB: {
                return CertificateBlob.parseContent(n, l, blobType, n2, keyBoxByteBuffer, blobVerifier);
            }
            case OPEN_PGP_BLOB: {
                return PublicKeyRingBlob.parseContent(n, l, blobType, n2, keyBoxByteBuffer, keyFingerPrintCalculator, blobVerifier);
            }
        }
        return null;
    }

    public BlobType getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }
}

