/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import java.util.function.Predicate;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.scheduler.LinkedScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.LocalScheduler;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.SortedScheduledEntries;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.scheduler.AbstractCacheEntryScheduler;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.ImmutableBeanEntry;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Group;

public class BeanExpirationScheduler<I, T>
extends AbstractCacheEntryScheduler<I, ImmutableBeanEntry<I>> {
    private final BeanFactory<I, T> factory;

    public BeanExpirationScheduler(Group group, Batcher<TransactionBatch> batcher, BeanFactory<I, T> factory, ExpirationConfiguration<T> expiration, BeanRemover<I, T> remover, Duration closeTimeout) {
        this((ScheduledEntries<I, Instant>)(group.isSingleton() ? new LinkedScheduledEntries() : new SortedScheduledEntries()), (Predicate<I> & Function<ImmutableBeanEntry<I>, Duration>)new BeanRemoveTask<I, T>(batcher, expiration, remover), factory, closeTimeout);
    }

    private <RT extends Predicate<I> & Function<ImmutableBeanEntry<I>, Duration>> BeanExpirationScheduler(ScheduledEntries<I, Instant> entries, RT removeTask, BeanFactory<I, T> factory, Duration closeTimeout) {
        super((Scheduler)new LocalScheduler(entries, removeTask, closeTimeout), (Function<ImmutableBeanEntry<I>, Duration>)removeTask, Duration::isNegative, ImmutableBeanEntry::getLastAccessedTime);
        this.factory = factory;
    }

    public void schedule(I id) {
        BeanEntry entry = (BeanEntry)this.factory.findValue(id);
        if (entry != null) {
            this.schedule(id, entry);
        }
    }

    private static class BeanRemoveTask<I, T>
    implements Predicate<I>,
    Function<ImmutableBeanEntry<I>, Duration> {
        private final Batcher<TransactionBatch> batcher;
        private final ExpirationConfiguration<T> expiration;
        private final BeanRemover<I, T> remover;

        BeanRemoveTask(Batcher<TransactionBatch> batcher, ExpirationConfiguration<T> expiration, BeanRemover<I, T> remover) {
            this.batcher = batcher;
            this.expiration = expiration;
            this.remover = remover;
        }

        @Override
        public boolean test(I id) {
            boolean bl;
            block10: {
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Expiring stateful session bean %s", id);
                Batch batch = this.batcher.createBatch();
                try {
                    this.remover.remove(id, this.expiration.getRemoveListener());
                    bl = true;
                    if (batch == null) break block10;
                }
                catch (RuntimeException e) {
                    try {
                        try {
                            batch.discard();
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (batch != null) {
                                try {
                                    batch.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    catch (RuntimeException e2) {
                        InfinispanEjbLogger.ROOT_LOGGER.failedToExpireBean(e2, id);
                        return false;
                    }
                }
                batch.close();
            }
            return bl;
        }

        @Override
        public Duration apply(ImmutableBeanEntry<I> entry) {
            return this.expiration.getTimeout();
        }
    }
}

