/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.List;
import java.util.function.Consumer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.cache.StateTransferConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.network.ClientMapping;
import org.wildfly.clustering.ejb.ClientMappingsRegistryProvider;
import org.wildfly.clustering.ejb.infinispan.ClientMappingsRegistryEntryServiceConfigurator;
import org.wildfly.clustering.infinispan.configuration.ConfigurationBuilderAttributesAccessor;
import org.wildfly.clustering.infinispan.container.DataContainerConfigurationBuilder;
import org.wildfly.clustering.infinispan.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.server.service.ProvidedCacheServiceConfigurator;
import org.wildfly.clustering.server.service.group.DistributedCacheGroupServiceConfiguratorProvider;
import org.wildfly.clustering.server.service.registry.DistributedRegistryServiceConfiguratorProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class LegacyInfinispanClientMappingsRegistryProvider
implements ClientMappingsRegistryProvider,
Consumer<ConfigurationBuilder> {
    private final String containerName;

    public LegacyInfinispanClientMappingsRegistryProvider(String containerName) {
        this.containerName = containerName;
    }

    public Iterable<CapabilityServiceConfigurator> getServiceConfigurators(String connectorName, SupplierDependency<List<ClientMapping>> clientMappings) {
        TemplateConfigurationServiceConfigurator configurationConfigurator = new TemplateConfigurationServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CONFIGURATION.getName()).append(new String[]{this.containerName, connectorName}), this.containerName, connectorName, null, (Consumer)this);
        CacheServiceConfigurator cacheConfigurator = new CacheServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CACHE.getName()).append(new String[]{this.containerName, connectorName}), this.containerName, connectorName);
        ClientMappingsRegistryEntryServiceConfigurator registryEntryConfigurator = new ClientMappingsRegistryEntryServiceConfigurator(this.containerName, connectorName, clientMappings);
        ProvidedCacheServiceConfigurator registryConfigurator = new ProvidedCacheServiceConfigurator(DistributedRegistryServiceConfiguratorProvider.class, this.containerName, connectorName);
        ProvidedCacheServiceConfigurator groupConfigurator = new ProvidedCacheServiceConfigurator(DistributedCacheGroupServiceConfiguratorProvider.class, this.containerName, connectorName);
        return List.of(configurationConfigurator, cacheConfigurator, registryEntryConfigurator, registryConfigurator, groupConfigurator);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        ClusteringConfigurationBuilder clustering;
        CacheMode mode = (clustering = builder.clustering()).cacheMode();
        clustering.cacheMode(mode.needsStateTransfer() ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
        clustering.l1().disable();
        AttributeSet attributes = ConfigurationBuilderAttributesAccessor.INSTANCE.apply((Object)clustering);
        attributes.attribute(ClusteringConfiguration.BIAS_ACQUISITION).reset();
        attributes.attribute(ClusteringConfiguration.BIAS_LIFESPAN).reset();
        attributes.attribute(ClusteringConfiguration.INVALIDATION_BATCH_SIZE).reset();
        ((DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class)).evictable(null);
        builder.expiration().lifespan(-1L).maxIdle(-1L);
        builder.memory().storage(StorageType.HEAP).maxCount(-1L).whenFull(EvictionStrategy.NONE);
        builder.persistence().clearStores();
        StateTransferConfigurationBuilder stateTransfer = clustering.stateTransfer().fetchInMemoryState(mode.needsStateTransfer());
        attributes = ConfigurationBuilderAttributesAccessor.INSTANCE.apply((Object)stateTransfer);
        attributes.attribute(StateTransferConfiguration.AWAIT_INITIAL_TRANSFER).reset();
        attributes.attribute(StateTransferConfiguration.TIMEOUT).reset();
    }
}

