/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public class ServerDependenciesProcessor
implements DeploymentUnitProcessor {
    private static ModuleIdentifier[] DEFAULT_MODULES = new ModuleIdentifier[]{ModuleIdentifier.create((String)"javax.api"), ModuleIdentifier.create((String)"org.jboss.vfs")};
    private static ModuleIdentifier[] DEFAULT_MODULES_WITH_SERVICE_IMPORTS = new ModuleIdentifier[]{ModuleIdentifier.create((String)"sun.jdk"), ModuleIdentifier.create((String)"ibm.jdk")};

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (ModuleIdentifier moduleId : DEFAULT_MODULES) {
            try {
                moduleLoader.loadModule(moduleId);
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleId, false, false, false, false));
            }
            catch (ModuleLoadException ex) {
                ServerLogger.ROOT_LOGGER.debugf("Module not found: %s", moduleId);
            }
        }
        for (ModuleIdentifier moduleId : DEFAULT_MODULES_WITH_SERVICE_IMPORTS) {
            try {
                moduleLoader.loadModule(moduleId);
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleId, false, false, true, false));
            }
            catch (ModuleLoadException ex) {
                ServerLogger.ROOT_LOGGER.debugf("Module not found: %s", moduleId);
            }
        }
    }
}

