/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class ByteElement
extends AtomicElement<Byte> {
    private final byte _value;

    ByteElement(Element parent, Element prev, byte b) {
        super(parent, prev);
        this._value = b;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 1 : 2;
    }

    @Override
    public Byte getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.BYTE;
    }

    @Override
    public int encode(ByteBuffer b) {
        if (this.isElementOfArray()) {
            if (b.hasRemaining()) {
                b.put(this._value);
                return 1;
            }
        } else if (b.remaining() >= 2) {
            b.put((byte)81);
            b.put(this._value);
            return 2;
        }
        return 0;
    }
}

