/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.utils;

import io.jaegertracing.internal.clock.Clock;
import io.jaegertracing.internal.clock.SystemClock;
import java.util.concurrent.atomic.AtomicLong;

public class RateLimiter {
    private final Clock clock;
    private final double creditsPerNanosecond;
    private final long maxBalance;
    private final AtomicLong debit;

    public RateLimiter(double creditsPerSecond, double maxBalance) {
        this(creditsPerSecond, maxBalance, new SystemClock());
    }

    public RateLimiter(double creditsPerSecond, double maxBalance, Clock clock) {
        this.clock = clock;
        this.creditsPerNanosecond = creditsPerSecond / 1.0E9;
        this.maxBalance = (long)(maxBalance / this.creditsPerNanosecond);
        this.debit = new AtomicLong(clock.currentNanoTicks() - this.maxBalance);
    }

    public boolean checkCredit(double itemCost) {
        long balance;
        long credit;
        long currentDebit;
        long cost = (long)(itemCost / this.creditsPerNanosecond);
        do {
            currentDebit = this.debit.get();
            credit = this.clock.currentNanoTicks();
            balance = credit - currentDebit;
            if (balance > this.maxBalance) {
                balance = this.maxBalance;
            }
            if ((balance -= cost) >= 0L) continue;
            return false;
        } while (!this.debit.compareAndSet(currentDebit, credit - balance));
        return true;
    }
}

