/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.NormalizerDefinition;
import org.hibernate.search.backend.elasticsearch.validation.impl.AnalysisDefinitionValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.AnalysisParameterEquivalenceRegistry;
import org.hibernate.search.backend.elasticsearch.validation.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;

class NormalizerDefinitionValidator
extends AnalysisDefinitionValidator<NormalizerDefinition> {
    NormalizerDefinitionValidator() {
        super(new AnalysisParameterEquivalenceRegistry.Builder().build());
    }

    @Override
    public void validate(ValidationErrorCollector errorCollector, NormalizerDefinition expectedDefinition, NormalizerDefinition actualDefinition) {
        super.validate(errorCollector, expectedDefinition, actualDefinition);
        if (!Objects.equals(expectedDefinition.getCharFilters(), actualDefinition.getCharFilters())) {
            errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidAnalyzerCharFilters(expectedDefinition.getCharFilters(), actualDefinition.getCharFilters()));
        }
        if (!Objects.equals(expectedDefinition.getTokenFilters(), actualDefinition.getTokenFilters())) {
            errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidAnalyzerTokenFilters(expectedDefinition.getTokenFilters(), actualDefinition.getTokenFilters()));
        }
    }

    @Override
    protected String getDefaultType() {
        return "custom";
    }
}

