/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.junit.Test;

public class JMSSelectorTest
extends JMSClientTestSupport {
    private static final String NORMAL_QUEUE_NAME = "NORMAL";
    private JMSClientTestSupport.ConnectionSupplier AMQPConnection = () -> this.createConnection();
    private JMSClientTestSupport.ConnectionSupplier CoreConnection = () -> this.createCoreConnection();
    private JMSClientTestSupport.ConnectionSupplier OpenWireConnection = () -> this.createOpenWireConnection();

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setPersistenceEnabled(false);
        server.getAddressSettingsRepository().addMatch(NORMAL_QUEUE_NAME, (Object)new AddressSettings());
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
        super.createAddressAndQueues(server);
        server.addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)NORMAL_QUEUE_NAME), RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(NORMAL_QUEUE_NAME).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testJMSSelectorsAMQPProducerAMQPConsumer() throws Exception {
        this.testJMSSelectors(this.AMQPConnection, this.AMQPConnection);
    }

    @Test
    public void testJMSSelectorsCoreProducerCoreConsumer() throws Exception {
        this.testJMSSelectors(this.CoreConnection, this.CoreConnection);
    }

    @Test
    public void testJMSSelectorsCoreProducerAMQPConsumer() throws Exception {
        this.testJMSSelectors(this.CoreConnection, this.AMQPConnection);
    }

    @Test
    public void testJMSSelectorsAMQPProducerCoreConsumer() throws Exception {
        this.testJMSSelectors(this.AMQPConnection, this.CoreConnection);
    }

    @Test
    public void testJMSSelectorsOpenWireProducerOpenWireConsumer() throws Exception {
        this.testJMSSelectors(this.OpenWireConnection, this.OpenWireConnection);
    }

    @Test
    public void testJMSSelectorsCoreProducerOpenWireConsumer() throws Exception {
        this.testJMSSelectors(this.CoreConnection, this.OpenWireConnection);
    }

    @Test
    public void testJMSSelectorsOpenWireProducerCoreConsumer() throws Exception {
        this.testJMSSelectors(this.OpenWireConnection, this.CoreConnection);
    }

    @Test
    public void testJMSSelectorsAMQPProducerOpenWireConsumer() throws Exception {
        this.testJMSSelectors(this.AMQPConnection, this.OpenWireConnection);
    }

    @Test
    public void testJMSSelectorsOpenWireProducerAMQPConsumer() throws Exception {
        this.testJMSSelectors(this.OpenWireConnection, this.AMQPConnection);
    }

    public void testJMSSelectors(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier) throws Exception {
        this.testJMSSelector(producerConnectionSupplier, consumerConnectionSupplier, NORMAL_QUEUE_NAME, message -> message.setStringProperty("color", "blue"), "color = 'blue'");
        this.testJMSSelector(producerConnectionSupplier, consumerConnectionSupplier, NORMAL_QUEUE_NAME, message -> message.setJMSCorrelationID("correlation"), "JMSCorrelationID = 'correlation'");
        this.testJMSSelector(producerConnectionSupplier, consumerConnectionSupplier, NORMAL_QUEUE_NAME, null, "JMSPriority = 1", 2, 1, 0L);
        this.testJMSSelector(producerConnectionSupplier, consumerConnectionSupplier, NORMAL_QUEUE_NAME, message -> message.setStringProperty("JMSXGroupID", "groupA"), "JMSXGroupID = 'groupA'");
    }

    public void testJMSSelector(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, MessageSetter setValue, String selector) throws Exception {
        this.testJMSSelector(producerConnectionSupplier, consumerConnectionSupplier, queueName, setValue, selector, 2, 4, 0L);
    }

    public void testJMSSelector(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, MessageSetter setValue, String selector, int deliveryMode, int priority, long timeToLive) throws Exception {
        this.sendMessage(producerConnectionSupplier, queueName, setValue, deliveryMode, priority, timeToLive);
        this.receiveLVQ(consumerConnectionSupplier, queueName, selector);
    }

    private void receiveLVQ(JMSClientTestSupport.ConnectionSupplier consumerConnectionSupplier, String queueName, String selector) throws JMSException {
        try (Connection consumerConnection = consumerConnectionSupplier.createConnection();){
            Session consumerSession = consumerConnection.createSession(false, 1);
            Queue consumerQueue = consumerSession.createQueue(queueName);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue, selector);
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            JMSSelectorTest.assertNotNull((Object)msg);
            JMSSelectorTest.assertEquals((Object)"how are you", (Object)msg.getText());
            JMSSelectorTest.assertNull((Object)consumer.receiveNoWait());
            consumer.close();
        }
    }

    private void sendMessage(JMSClientTestSupport.ConnectionSupplier producerConnectionSupplier, String queueName, MessageSetter setValue, int deliveryMode, int priority, long timeToLive) throws JMSException {
        try (Connection producerConnection = producerConnectionSupplier.createConnection();){
            Session producerSession = producerConnection.createSession(false, 1);
            Queue queue1 = producerSession.createQueue(queueName);
            MessageProducer p = producerSession.createProducer(null);
            TextMessage message1 = producerSession.createTextMessage();
            message1.setText("hello");
            p.send((Destination)queue1, (Message)message1);
            TextMessage message2 = producerSession.createTextMessage();
            if (setValue != null) {
                setValue.accept((Message)message2);
            }
            message2.setText("how are you");
            p.send((Destination)queue1, (Message)message2, deliveryMode, priority, timeToLive);
        }
    }

    public static interface MessageSetter {
        public void accept(Message var1) throws JMSException;
    }
}

