/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateQueueIdempotentTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)true));
        this.server.start();
    }

    @Test
    public void testSequentialCreateQueueIdempotency() throws Exception {
        SimpleString QUEUE = new SimpleString("SequentialCreateQueueIdempotency");
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE));
        try {
            session.createQueue(new QueueConfiguration(QUEUE));
            CreateQueueIdempotentTest.fail((String)"Expected exception, queue already exists");
        }
        catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
        }
        catch (ActiveMQException e) {
            CreateQueueIdempotentTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    public void testConcurrentCreateQueueIdempotency() throws Exception {
        int i;
        String QUEUE = "ConcurrentCreateQueueIdempotency";
        AtomicInteger queuesCreated = new AtomicInteger(0);
        AtomicInteger failedAttempts = new AtomicInteger(0);
        int NUM_THREADS = 5;
        QueueCreator[] queueCreators = new QueueCreator[5];
        for (i = 0; i < 5; ++i) {
            QueueCreator queueCreator;
            queueCreators[i] = queueCreator = new QueueCreator("ConcurrentCreateQueueIdempotency", queuesCreated, failedAttempts);
        }
        for (i = 0; i < 5; ++i) {
            queueCreators[i].start();
        }
        for (i = 0; i < 5; ++i) {
            queueCreators[i].join();
        }
        this.server.stop();
        this.server.start();
        Assert.assertEquals((long)1L, (long)queuesCreated.intValue());
        Assert.assertEquals((long)4L, (long)failedAttempts.intValue());
    }

    class QueueCreator
    extends Thread {
        private String queueName = null;
        private AtomicInteger queuesCreated = null;
        private AtomicInteger failedAttempts = null;

        QueueCreator(String queueName, AtomicInteger queuesCreated, AtomicInteger failedAttempts) {
            this.queueName = queueName;
            this.queuesCreated = queuesCreated;
            this.failedAttempts = failedAttempts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerLocator locator = null;
            ClientSession session = null;
            try {
                locator = CreateQueueIdempotentTest.this.createInVMNonHALocator();
                ClientSessionFactory sf = CreateQueueIdempotentTest.this.createSessionFactory(locator);
                session = sf.createSession(false, true, true);
                SimpleString QUEUE = new SimpleString(this.queueName);
                session.createQueue(new QueueConfiguration(QUEUE));
                this.queuesCreated.incrementAndGet();
            }
            catch (ActiveMQQueueExistsException qne) {
                this.failedAttempts.incrementAndGet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locator != null) {
                    locator.close();
                }
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (ActiveMQException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

