/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpiryAddressTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession clientSession;
    private ServerLocator locator;

    @Test
    public void testBasicSend() throws Exception {
        SimpleString ea = new SimpleString("EA");
        SimpleString adSend = new SimpleString("a1");
        SimpleString qName = new SimpleString("q1");
        SimpleString eq = new SimpleString("EA1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.clientSession.createQueue(new QueueConfiguration(eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setAddress(adSend).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(adSend);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(eq);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)qName.toString(), (Object)m.getStringProperty(Message.HDR_ORIGINAL_QUEUE));
        Assert.assertEquals((Object)adSend.toString(), (Object)m.getStringProperty(Message.HDR_ORIGINAL_ADDRESS));
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Test
    public void testExpireSingleMessage() throws Exception {
        SimpleString ea = new SimpleString("EA");
        SimpleString adSend = new SimpleString("a1");
        SimpleString qName = new SimpleString("q1");
        SimpleString eq = new SimpleString("EA1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.clientSession.createQueue(new QueueConfiguration(eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setAddress(adSend).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(adSend);
        for (int i = 0; i < 2100; ++i) {
            ClientMessage clientMessage = this.createTextMessage(this.clientSession, "notExpired!");
            clientMessage.putIntProperty("i", i);
            producer.send((Message)clientMessage);
        }
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        Queue queueQ1 = this.server.locateQueue("q1");
        CountDownLatch latch = new CountDownLatch(10);
        for (int i = 0; i < 10; ++i) {
            queueQ1.expireReferences(latch::countDown);
        }
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(eq);
        ClientMessage m = clientConsumer.receive(5000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)qName.toString(), (Object)m.getStringProperty(Message.HDR_ORIGINAL_QUEUE));
        Assert.assertEquals((Object)adSend.toString(), (Object)m.getStringProperty(Message.HDR_ORIGINAL_ADDRESS));
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Test
    public void testBasicSendWithRetroActiveAddressSettings() throws Exception {
        SimpleString expiryAddress1 = new SimpleString("expiryAddress1");
        SimpleString qName = new SimpleString("q1");
        SimpleString expiryQueue1 = new SimpleString("expiryQueue1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(expiryAddress1);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        this.clientSession.createQueue(new QueueConfiguration(expiryQueue1).setAddress(expiryAddress1).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        SimpleString expiryAddress2 = new SimpleString("expiryAddress2");
        SimpleString expiryQueue2 = new SimpleString("expiryQueue2");
        addressSettings = new AddressSettings().setExpiryAddress(expiryAddress2);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        this.clientSession.createQueue(new QueueConfiguration(expiryQueue2).setAddress(expiryAddress2).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(expiryQueue1);
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(expiryQueue2);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Test
    public void testBasicSendToMultipleQueues() throws Exception {
        SimpleString ea = new SimpleString("EA");
        SimpleString qName = new SimpleString("q1");
        SimpleString eq = new SimpleString("EQ1");
        SimpleString eq2 = new SimpleString("EQ2");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        this.clientSession.createQueue(new QueueConfiguration(eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(eq2).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(eq);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        ExpiryAddressTest.assertNotNull((Object)m.getStringProperty(Message.HDR_ORIGINAL_ADDRESS));
        ExpiryAddressTest.assertNotNull((Object)m.getStringProperty(Message.HDR_ORIGINAL_QUEUE));
        m.acknowledge();
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(eq2);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        ExpiryAddressTest.assertNotNull((Object)m.getStringProperty(Message.HDR_ORIGINAL_ADDRESS));
        ExpiryAddressTest.assertNotNull((Object)m.getStringProperty(Message.HDR_ORIGINAL_QUEUE));
        m.acknowledge();
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        clientConsumer.close();
        this.clientSession.commit();
    }

    @Test
    public void testBasicSendToNoQueue() throws Exception {
        SimpleString ea = new SimpleString("EA");
        SimpleString qName = new SimpleString("q1");
        SimpleString eq = new SimpleString("EQ1");
        SimpleString eq2 = new SimpleString("EQ2");
        this.clientSession.createQueue(new QueueConfiguration(eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(eq2).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
    }

    @Test
    public void testHeadersSet() throws Exception {
        int NUM_MESSAGES = 5;
        SimpleString ea = new SimpleString("DLA");
        SimpleString qName = new SimpleString("q1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        SimpleString eq = new SimpleString("EA1");
        this.clientSession.createQueue(new QueueConfiguration(eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        ServerLocator locator1 = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator1);
        ClientSession sendSession = sessionFactory.createSession(false, true, true);
        ClientProducer producer = sendSession.createProducer(qName);
        long expiration = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = this.createTextMessage(this.clientSession, "Message:" + i);
            tm.setExpiration(expiration);
            producer.send((Message)tm);
        }
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        this.clientSession.start();
        ClientMessage m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        ClientConsumer cc3 = this.clientSession.createConsumer(eq);
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = cc3.receive(1000L);
            Assert.assertNotNull((Object)tm);
            String text = tm.getBodyBuffer().readString();
            Assert.assertEquals((Object)("Message:" + i), (Object)text);
            Long actualExpiryTime = (Long)tm.getObjectProperty(Message.HDR_ACTUAL_EXPIRY_TIME);
            Assert.assertTrue((actualExpiryTime >= expiration ? (byte)1 : 0) != 0);
        }
        sendSession.close();
        locator1.close();
    }

    @Test
    public void testExpireWithDefaultAddressSettings() throws Exception {
        SimpleString ea = new SimpleString("EA");
        SimpleString qName = new SimpleString("q1");
        SimpleString eq = new SimpleString("EA1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().setDefault((Object)addressSettings);
        this.clientSession.createQueue(new QueueConfiguration(eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(eq);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Test
    public void testExpireWithWildcardAddressSettings() throws Exception {
        SimpleString ea = new SimpleString("EA");
        SimpleString qName = new SimpleString("q1");
        SimpleString eq = new SimpleString("EA1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().addMatch("*", (Object)addressSettings);
        this.clientSession.createQueue(new QueueConfiguration(eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(eq);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Test
    public void testExpireWithOverridenSublevelAddressSettings() throws Exception {
        SimpleString address = new SimpleString("prefix.address");
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString defaultExpiryAddress = RandomUtil.randomSimpleString();
        SimpleString defaultExpiryQueue = RandomUtil.randomSimpleString();
        SimpleString specificExpiryAddress = RandomUtil.randomSimpleString();
        SimpleString specificExpiryQueue = RandomUtil.randomSimpleString();
        AddressSettings defaultAddressSettings = new AddressSettings().setExpiryAddress(defaultExpiryAddress);
        this.server.getAddressSettingsRepository().addMatch("prefix.*", (Object)defaultAddressSettings);
        AddressSettings specificAddressSettings = new AddressSettings().setExpiryAddress(specificExpiryAddress);
        this.server.getAddressSettingsRepository().addMatch("prefix.address", (Object)specificAddressSettings);
        this.clientSession.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(defaultExpiryQueue).setAddress(defaultExpiryAddress).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(new QueueConfiguration(specificExpiryQueue).setAddress(specificExpiryAddress).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(address);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queue);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(defaultExpiryQueue);
        m = clientConsumer.receiveImmediate();
        Assert.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(specificExpiryQueue);
        m = clientConsumer.receive(500L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)false));
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnAcknowledge(true);
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(sessionFactory.createSession(null, null, false, true, true, false, 0));
    }
}

