/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NewDeadLetterAddressTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession clientSession;
    private ServerLocator locator;

    @Test
    public void testSendToDLAWhenNoRoute() throws Exception {
        SimpleString dla = new SimpleString("DLA");
        SimpleString address = new SimpleString("empty_address");
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(dla).setSendToDLAOnNoRoute(true);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        SimpleString dlq = new SimpleString("DLQ1");
        this.clientSession.createQueue(new QueueConfiguration(dlq).setAddress(dla).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(address);
        producer.send((Message)this.createTextMessage(this.clientSession, "heyho!"));
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(dlq);
        ClientMessage m = clientConsumer.receive(500L);
        m.acknowledge();
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)false));
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = sessionFactory.createSession(false, true, false);
    }
}

