/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.MessageCounterInfo;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ClusteredMessageCounterTest
extends ClusterTestBase {
    private AtomicInteger total = new AtomicInteger();
    private AtomicBoolean stopFlag = new AtomicBoolean();
    private Timer timer1 = new Timer();
    private Timer timer2 = new Timer();
    private int numMsg = 1000;
    private List<MessageCounterInfo> results = new ArrayList<MessageCounterInfo>();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
        this.setupClusters();
        this.total.set(0);
        this.stopFlag.set(false);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.timer1.cancel();
        this.timer2.cancel();
        super.tearDown();
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
    }

    protected void setupClusters() {
        this.setupClusterConnection("cluster0", 0, 1, "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), false);
        this.setupClusterConnection("cluster1", 1, 0, "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), false);
    }

    protected boolean isNetty() {
        return true;
    }

    protected ConfigurationImpl createBasicConfig(int serverID) {
        ConfigurationImpl config = super.createBasicConfig(serverID);
        Map addrSettingsMap = config.getAddressesSettings();
        AddressSettings addrSettings = new AddressSettings();
        addrSettings.setMaxSizeBytes(10240L);
        addrSettings.setPageSizeBytes(5120);
        addrSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addrSettingsMap.put("queues", addrSettings);
        if (serverID == 1) {
            config.setMessageCounterEnabled(true);
        }
        return config;
    }

    @Test
    public void testNonDurableMessageAddedWithPaging() throws Exception {
        this.testMessageAddedWithPaging(false);
    }

    @Test
    public void testDurableMessageAddedWithPaging() throws Exception {
        this.testMessageAddedWithPaging(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMessageAddedWithPaging(boolean durable) throws Exception {
        this.startServers(0, 1);
        this.numMsg = 100;
        try {
            this.setupSessionFactory(0, this.isNetty());
            this.setupSessionFactory(1, this.isNetty());
            this.createQueue(0, "queues", "queue0", null, false);
            this.createQueue(1, "queues", "queue0", null, false);
            this.waitForBindings(1, "queues", 1, 0, true);
            this.waitForBindings(0, "queues", 1, 0, false);
            this.addConsumer(1, 1, "queue0", null);
            this.waitForBindings(0, "queues", 1, 1, false);
            this.send(0, "queues", this.numMsg, durable, null);
            this.verifyReceiveAllOnSingleConsumer(true, 0, this.numMsg, 1);
            QueueControl control = (QueueControl)this.servers[1].getManagementService().getResource("queue.queue0");
            for (long timeout = 30000L; timeout > 0L && (long)this.numMsg != control.getMessagesAdded(); timeout -= 1000L) {
                Thread.sleep(1000L);
            }
            ClusteredMessageCounterTest.assertEquals((long)this.numMsg, (long)control.getMessagesAdded());
        }
        catch (Throwable throwable) {
            this.stopServers(0, 1);
            throw throwable;
        }
        this.stopServers(0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageCounterWithPaging() throws Exception {
        this.startServers(0, 1);
        try {
            this.setupSessionFactory(0, this.isNetty());
            this.setupSessionFactory(1, this.isNetty());
            this.createQueue(0, "queues", "queue0", null, false);
            this.createQueue(1, "queues", "queue0", null, false);
            this.waitForBindings(1, "queues", 1, 0, true);
            this.waitForBindings(0, "queues", 1, 0, false);
            Thread sendThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClusteredMessageCounterTest.this.send(0, "queues", ClusteredMessageCounterTest.this.numMsg, true, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            QueueControl control = (QueueControl)this.servers[1].getManagementService().getResource("queue.queue0");
            ActiveMQServerControl serverControl = (ActiveMQServerControl)this.servers[1].getManagementService().getResource("broker");
            serverControl.setMessageCounterSamplePeriod(300L);
            CountDownLatch resultLatch = new CountDownLatch(40);
            MessageCounterCollector collector = new MessageCounterCollector(control, resultLatch);
            this.timer1.schedule((TimerTask)collector, 0L);
            PeriodicalReceiver receiver = new PeriodicalReceiver(50, 1, 100L);
            this.timer2.schedule((TimerTask)receiver, 0L);
            sendThread.start();
            try {
                resultLatch.await(120L, TimeUnit.SECONDS);
            }
            finally {
                this.stopFlag.set(true);
            }
            sendThread.join();
            for (MessageCounterInfo info : this.results) {
                ClusteredMessageCounterTest.assertTrue((String)("countDelta should be positive " + info.getCountDelta() + this.dumpResults(this.results)), (info.getCountDelta() >= 0L ? (byte)1 : 0) != 0);
            }
            this.timer1.cancel();
            this.timer2.cancel();
        }
        catch (Throwable throwable) {
            this.timer1.cancel();
            this.timer2.cancel();
            this.stopServers(0, 1);
            throw throwable;
        }
        this.stopServers(0, 1);
    }

    private String dumpResults(List<MessageCounterInfo> results) {
        StringBuilder builder = new StringBuilder("\n");
        for (int i = 0; i < results.size(); ++i) {
            builder.append("result[" + i + "]: " + results.get(i).getCountDelta() + " " + results.get(i).getCount() + "\n");
        }
        return builder.toString();
    }

    private class PeriodicalReceiver
    extends TimerTask {
        private int batchSize;
        private int serverID;
        private long period;

        PeriodicalReceiver(int batchSize, int serverID, long period) {
            this.batchSize = batchSize;
            this.serverID = serverID;
            this.period = period;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int num;
            if (ClusteredMessageCounterTest.this.stopFlag.get()) {
                return;
            }
            ClientSessionFactory sf = ClusteredMessageCounterTest.this.sfs[this.serverID];
            ClientSession session = null;
            ClientConsumer consumer = null;
            try {
                ClientMessage message;
                session = sf.createSession(false, true, false);
                consumer = session.createConsumer("queue0", null);
                session.start();
                for (num = 0; (num < this.batchSize || ClusteredMessageCounterTest.this.stopFlag.get()) && (message = consumer.receive(2000L)) != null; ++num) {
                    message.acknowledge();
                }
                session.commit();
            }
            catch (ActiveMQException e) {
                e.printStackTrace();
            }
            finally {
                if (consumer != null) {
                    try {
                        consumer.close();
                    }
                    catch (ActiveMQException e) {
                        e.printStackTrace();
                    }
                }
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (ActiveMQException e) {
                        e.printStackTrace();
                    }
                }
                if (!ClusteredMessageCounterTest.this.stopFlag.get() && ClusteredMessageCounterTest.this.total.addAndGet(num) < ClusteredMessageCounterTest.this.numMsg - 200) {
                    ClusteredMessageCounterTest.this.timer2.schedule((TimerTask)new PeriodicalReceiver(this.batchSize, this.serverID, this.period), this.period);
                }
            }
        }
    }

    private class MessageCounterCollector
    extends TimerTask {
        private QueueControl queueControl;
        private CountDownLatch resultLatch;

        MessageCounterCollector(QueueControl queueControl, CountDownLatch resultLatch) {
            this.queueControl = queueControl;
            this.resultLatch = resultLatch;
        }

        @Override
        public void run() {
            if (ClusteredMessageCounterTest.this.stopFlag.get()) {
                return;
            }
            try {
                String result = this.queueControl.listMessageCounter();
                MessageCounterInfo info = MessageCounterInfo.fromJSON((String)result);
                ClusteredMessageCounterTest.this.results.add(info);
                this.resultLatch.countDown();
                if (info.getCountDelta() < 0L) {
                    ClusteredMessageCounterTest.this.stopFlag.set(true);
                    while (this.resultLatch.getCount() > 0L) {
                        this.resultLatch.countDown();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!ClusteredMessageCounterTest.this.stopFlag.get()) {
                    ClusteredMessageCounterTest.this.timer1.schedule((TimerTask)new MessageCounterCollector(this.queueControl, this.resultLatch), 200L);
                }
            }
        }
    }
}

