/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.topology;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class IsolatedTopologyTest
extends ActiveMQTestBase {
    @Test
    public void testIsolatedClusters() throws Exception {
        ActiveMQServer server1 = this.createServer1();
        ActiveMQServer server2 = this.createServer2();
        server1.start();
        server2.start();
        this.waitForTopology(server1, "cc1", 2, 5000L);
        this.waitForTopology(server1, "cc2", 2, 5000L);
        this.waitForTopology(server2, "cc1", 2, 5000L);
        this.waitForTopology(server2, "cc2", 2, 5000L);
        String node1 = server1.getNodeID().toString();
        String node2 = server2.getNodeID().toString();
        this.checkTopology(server1, "cc1", node1, node2, this.createInVMTransportConnectorConfig(1, "srv1"), this.createInVMTransportConnectorConfig(3, "srv1"));
        this.checkTopology(server2, "cc1", node1, node2, this.createInVMTransportConnectorConfig(1, "srv1"), this.createInVMTransportConnectorConfig(3, "srv1"));
        this.checkTopology(server1, "cc2", node1, node2, this.createInVMTransportConnectorConfig(2, "srv1"), this.createInVMTransportConnectorConfig(4, "srv1"));
        this.checkTopology(server2, "cc2", node1, node2, this.createInVMTransportConnectorConfig(2, "srv1"), this.createInVMTransportConnectorConfig(4, "srv1"));
        Thread.sleep(500L);
    }

    private void checkTopology(ActiveMQServer serverParameter, String clusterName, String nodeId1, String nodeId2, TransportConfiguration cfg1, TransportConfiguration cfg2) {
        Topology topology = serverParameter.getClusterManager().getClusterConnection(clusterName).getTopology();
        TopologyMemberImpl member1 = topology.getMember(nodeId1);
        TopologyMemberImpl member2 = topology.getMember(nodeId2);
        Assert.assertEquals((Object)member1.getLive().getParams().toString(), (Object)cfg1.getParams().toString());
        Assert.assertEquals((Object)member2.getLive().getParams().toString(), (Object)cfg2.getParams().toString());
    }

    private ActiveMQServer createServer1() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("clusterConnection", "cc1");
        params.put("serverId", "1");
        TransportConfiguration acceptor1VM1 = new TransportConfiguration(ActiveMQTestBase.INVM_ACCEPTOR_FACTORY, params, "acceptor-cc1");
        params = new HashMap();
        params.put("clusterConnection", "cc2");
        params.put("serverId", "2");
        TransportConfiguration acceptor2VM1 = new TransportConfiguration(ActiveMQTestBase.INVM_ACCEPTOR_FACTORY, params, "acceptor-cc2");
        ArrayList<String> connectTo = new ArrayList<String>();
        connectTo.add("other-cc1");
        ClusterConnectionConfiguration server1CC1 = new ClusterConnectionConfiguration().setName("cc1").setAddress("jms").setConnectorName("local-cc1").setRetryInterval(250L).setConfirmationWindowSize(1024).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(connectTo);
        ArrayList<String> connectTo2 = new ArrayList<String>();
        connectTo2.add("other-cc2");
        ClusterConnectionConfiguration server1CC2 = new ClusterConnectionConfiguration().setName("cc2").setAddress("jms").setConnectorName("local-cc2").setRetryInterval(250L).setConfirmationWindowSize(1024).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(connectTo2);
        ConfigurationImpl config1 = this.createBasicConfig(1).addConnectorConfiguration("local-cc1", this.createInVMTransportConnectorConfig(1, "local-cc1")).addConnectorConfiguration("local-cc2", this.createInVMTransportConnectorConfig(2, "local-cc2")).addConnectorConfiguration("other-cc1", this.createInVMTransportConnectorConfig(3, "other-cc1")).addConnectorConfiguration("other-cc2", this.createInVMTransportConnectorConfig(4, "other-cc2")).addAcceptorConfiguration(acceptor1VM1).addAcceptorConfiguration(acceptor2VM1).addClusterConfiguration(server1CC1).addClusterConfiguration(server1CC2);
        return this.createServer(false, (Configuration)config1);
    }

    private ActiveMQServer createServer2() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("clusterConnection", "cc1");
        params.put("serverId", "3");
        TransportConfiguration acceptor1VM1 = new TransportConfiguration(ActiveMQTestBase.INVM_ACCEPTOR_FACTORY, params, "acceptor-cc1");
        params = new HashMap();
        params.put("clusterConnection", "cc2");
        params.put("serverId", "4");
        TransportConfiguration acceptor2VM1 = new TransportConfiguration(ActiveMQTestBase.INVM_ACCEPTOR_FACTORY, params, "acceptor-cc2");
        ArrayList<String> connectTo = new ArrayList<String>();
        connectTo.add("other-cc1");
        ClusterConnectionConfiguration server1CC1 = new ClusterConnectionConfiguration().setName("cc1").setAddress("jms").setConnectorName("local-cc1").setRetryInterval(250L).setConfirmationWindowSize(1024).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(connectTo);
        ArrayList<String> connectTo2 = new ArrayList<String>();
        connectTo2.add("other-cc2");
        ClusterConnectionConfiguration server1CC2 = new ClusterConnectionConfiguration().setName("cc2").setAddress("jms").setConnectorName("local-cc2").setRetryInterval(250L).setConfirmationWindowSize(1024).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(connectTo2);
        ConfigurationImpl config1 = this.createBasicConfig(2).addAcceptorConfiguration(acceptor1VM1).addAcceptorConfiguration(acceptor2VM1).addConnectorConfiguration("local-cc1", this.createInVMTransportConnectorConfig(3, "local-cc1")).addConnectorConfiguration("local-cc2", this.createInVMTransportConnectorConfig(4, "local-cc2")).addConnectorConfiguration("other-cc1", this.createInVMTransportConnectorConfig(1, "other-cc1")).addConnectorConfiguration("other-cc2", this.createInVMTransportConnectorConfig(2, "other-cc2")).addClusterConfiguration(server1CC1).addClusterConfiguration(server1CC2);
        return this.createServer(false, (Configuration)config1);
    }
}

