/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jdbc.store.journal;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShutdownServerTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString QUEUE = new SimpleString("ConsumerTestQueue");
    private ServerLocator locator;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, this.createDefaultJDBCConfig(false), 0xA00000, -1L);
        this.server.start();
        this.locator = this.createFactory(false);
    }

    @Test
    public void testShutdownServer() throws Throwable {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true, false);
        session.createQueue(new QueueConfiguration(this.QUEUE));
        ClientConsumer consumer = session.createConsumer(this.QUEUE);
        ClientProducer producer = session.createProducer(this.QUEUE);
        ClientMessage message = session.createMessage((byte)3, true, 0L, System.currentTimeMillis(), (byte)4);
        message.getBodyBuffer().writeString("hi");
        message.putStringProperty("hello", "elo");
        producer.send((Message)message);
        ActiveMQServerImpl impl = (ActiveMQServerImpl)this.server;
        JournalStorageManager journal = (JournalStorageManager)impl.getStorageManager();
        JDBCJournalImpl journalimpl = (JDBCJournalImpl)journal.getMessageJournal();
        journalimpl.handleException(null, (Throwable)new Exception("failure"));
        Wait.waitFor(() -> !this.server.isStarted());
        Assert.assertFalse((boolean)this.server.isStarted());
    }
}

