/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.jboss.logging.Logger;
import org.junit.Before;
import org.junit.Test;

public class RollbackTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;
    private static Logger log = Logger.getLogger(RollbackTest.class);

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig());
        this.server.getConfiguration().getIncomingInterceptorClassNames().add(MyInterceptor.class.getName());
        this.server.start();
    }

    @Test
    public void testFailedRollback() throws Exception {
        String TOPIC = "myTopic";
        String SUBSCRIPTION = "mySub";
        try (ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://0");){
            connectionFactory.setCallTimeout(1000L);
            connectionFactory.setReconnectAttempts(-1);
            connectionFactory.setConfirmationWindowSize(0x100000);
            try (Connection consumerConnection = connectionFactory.createConnection();){
                Message m2;
                consumerConnection.start();
                Session session = consumerConnection.createSession(0);
                Topic topic = session.createTopic("myTopic");
                MessageConsumer messageConsumer = session.createSharedDurableConsumer(topic, "mySub");
                MessageProducer p = session.createProducer((Destination)topic);
                p.send(session.createMessage());
                p.close();
                session.commit();
                try {
                    m2 = messageConsumer.receive(2000L);
                    RollbackTest.assertNotNull((Object)m2);
                    session.rollback();
                    RollbackTest.fail();
                }
                catch (JMSException m2) {
                    // empty catch block
                }
                try {
                    session.rollback();
                }
                catch (JMSException e) {
                    RollbackTest.fail((String)("Rollback failed again! Giving up. " + e.getMessage()));
                }
                m2 = messageConsumer.receive(2000L);
                RollbackTest.assertNotNull((Object)m2);
                try {
                    session.commit();
                }
                catch (JMSException e) {
                    RollbackTest.fail((String)("Commit failed. " + e.getMessage()));
                }
            }
        }
        RollbackTest.assertEquals((long)0L, (long)this.server.locateQueue("mySub").getMessageCount());
    }

    public static class MyInterceptor
    implements Interceptor {
        private boolean intercepted = false;

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (!this.intercepted && packet.getType() == 44) {
                this.intercepted = true;
                return false;
            }
            return true;
        }
    }
}

