/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.impl.BindingsImpl;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Test;

public class TopicCleanupTest
extends JMSTestBase {
    @Override
    protected boolean usePersistence() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendTopic() throws Exception {
        Topic topic = this.createTopic("topic");
        Connection conn = this.cf.createConnection();
        try {
            conn.setClientID("someID");
            Session sess = conn.createSession(false, 1);
            TopicSubscriber cons = sess.createDurableSubscriber(topic, "someSub");
            conn.start();
            MessageProducer prod = sess.createProducer((Destination)topic);
            TextMessage msg1 = sess.createTextMessage("text");
            prod.send((Message)msg1);
            TopicCleanupTest.assertNotNull((Object)cons.receive(5000L));
            conn.close();
            StorageManager storage = this.server.getStorageManager();
            for (int i = 0; i < 100; ++i) {
                long txid = storage.generateID();
                QueueImpl queue = new QueueImpl(storage.generateID(), SimpleString.toSimpleString((String)"topic"), SimpleString.toSimpleString((String)"topic"), FilterImpl.createFilter((String)"__AMQX=-1"), null, true, false, false, this.server.getScheduledPool(), this.server.getPostOffice(), storage, this.server.getAddressSettingsRepository(), this.server.getExecutorFactory().getExecutor(), this.server, null);
                LocalQueueBinding binding = new LocalQueueBinding(queue.getAddress(), (Queue)queue, this.server.getNodeID());
                storage.addQueueBinding(txid, (Binding)binding);
                storage.commitBindings(txid);
            }
            this.jmsServer.stop();
            this.jmsServer.start();
        }
        finally {
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWildcardSubscriber() throws Exception {
        ActiveMQTopic topic = (ActiveMQTopic)this.createTopic("topic.A");
        Connection conn = this.cf.createConnection();
        conn.start();
        try {
            Session consumerStarSession = conn.createSession(false, 1);
            MessageConsumer consumerStar = consumerStarSession.createConsumer((Destination)ActiveMQJMSClient.createTopic((String)"topic.*"));
            Session consumerASession = conn.createSession(false, 1);
            MessageConsumer consumerA = consumerASession.createConsumer((Destination)topic);
            Session producerSession = conn.createSession(false, 1);
            MessageProducer producerA = producerSession.createProducer((Destination)topic);
            TextMessage msg1 = producerSession.createTextMessage("text");
            producerA.send((Message)msg1);
            consumerStar.close();
            consumerA.close();
            producerA.send((Message)msg1);
            conn.close();
            boolean foundStrayRoutingBinding = false;
            Bindings bindings = this.server.getPostOffice().getBindingsForAddress(new SimpleString(topic.getAddress()));
            Map routingNames = ((BindingsImpl)bindings).getRoutingNameBindingMap();
            for (SimpleString key : routingNames.keySet()) {
                if (key.toString().equals(topic.getAddress())) continue;
                foundStrayRoutingBinding = true;
                TopicCleanupTest.assertEquals((long)0L, (long)((LocalQueueBinding)((List)routingNames.get(key)).get(0)).getQueue().getMessageCount());
            }
            TopicCleanupTest.assertFalse((boolean)foundStrayRoutingBinding);
        }
        finally {
            this.jmsServer.stop();
            this.jmsServer.start();
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

