/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.Map;
import org.apache.activemq.artemis.api.core.management.ClusterConnectionControl;
import org.apache.activemq.artemis.tests.integration.management.ClusterConnectionControlTest;
import org.apache.activemq.artemis.tests.integration.management.CoreMessagingProxy;

public class ClusterConnectionControlUsingCoreTest
extends ClusterConnectionControlTest {
    @Override
    protected ClusterConnectionControl createManagementControl(final String name) throws Exception {
        return new ClusterConnectionControl(){
            private final CoreMessagingProxy proxy;
            {
                this.proxy = new CoreMessagingProxy(ClusterConnectionControlUsingCoreTest.this.addServerLocator(ClusterConnectionControlUsingCoreTest.this.createInVMNonHALocator()), "clusterconnection." + name);
            }

            public Object[] getStaticConnectors() {
                return (Object[])this.proxy.retrieveAttributeValue("staticConnectors");
            }

            public String getStaticConnectorsAsJSON() throws Exception {
                return (String)this.proxy.retrieveAttributeValue("staticConnectorsAsJSON");
            }

            public String getAddress() {
                return (String)this.proxy.retrieveAttributeValue("address");
            }

            public String getDiscoveryGroupName() {
                return (String)this.proxy.retrieveAttributeValue("discoveryGroupName");
            }

            public int getMaxHops() {
                return (Integer)this.proxy.retrieveAttributeValue("maxHops", Integer.class);
            }

            public long getRetryInterval() {
                return (Long)this.proxy.retrieveAttributeValue("retryInterval", Long.class);
            }

            public String getTopology() {
                return (String)this.proxy.retrieveAttributeValue("topology");
            }

            public Map<String, String> getNodes() throws Exception {
                return (Map)this.proxy.retrieveAttributeValue("nodes");
            }

            public boolean isDuplicateDetection() {
                return (Boolean)this.proxy.retrieveAttributeValue("duplicateDetection", Boolean.class);
            }

            public String getMessageLoadBalancingType() {
                return (String)this.proxy.retrieveAttributeValue("messageLoadBalancingType");
            }

            public String getName() {
                return (String)this.proxy.retrieveAttributeValue("name");
            }

            public String getNodeID() {
                return (String)this.proxy.retrieveAttributeValue("nodeID");
            }

            public long getMessagesPendingAcknowledgement() {
                return (Long)this.proxy.retrieveAttributeValue("messagesPendingAcknowledgement", Long.class);
            }

            public long getMessagesAcknowledged() {
                return (Long)this.proxy.retrieveAttributeValue("messagesAcknowledged", Long.class);
            }

            public Map<String, Object> getMetrics() {
                return (Map)this.proxy.retrieveAttributeValue("metrics", Map.class);
            }

            public Map<String, Object> getBridgeMetrics(String nodeId) throws Exception {
                return (Map)this.proxy.invokeOperation("getBridgeMetrics", nodeId);
            }

            public boolean isStarted() {
                return (Boolean)this.proxy.retrieveAttributeValue("started", Boolean.class);
            }

            public void start() throws Exception {
                this.proxy.invokeOperation("start", new Object[0]);
            }

            public void stop() throws Exception {
                this.proxy.invokeOperation("stop", new Object[0]);
            }
        };
    }
}

