/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt.imported;

import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import jakarta.jms.ConnectionFactory;
import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.remoting.impl.AbstractAcceptor;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.FuseMQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.imported.MQTTClientProvider;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.fusesource.hawtdispatch.DispatchPriority;
import org.fusesource.hawtdispatch.internal.DispatcherConfig;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.Tracer;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class MQTTTestSupport
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(MQTTTestSupport.class);
    protected ActiveMQServer server;
    protected int port = 1883;
    protected ConnectionFactory cf;
    protected LinkedList<Throwable> exceptions = new LinkedList();
    protected boolean persistent;
    protected String protocolConfig;
    protected String protocolScheme = "mqtt";
    protected boolean useSSL = false;
    protected static final int NUM_MESSAGES = 250;
    public static final int AT_MOST_ONCE = 0;
    public static final int AT_LEAST_ONCE = 1;
    public static final int EXACTLY_ONCE = 2;
    protected String noprivUser = "noprivs";
    protected String noprivPass = "noprivs";
    protected String browseUser = "browser";
    protected String browsePass = "browser";
    protected String guestUser = "guest";
    protected String guestPass = "guest";
    protected String fullUser = "user";
    protected String fullPass = "pass";
    @Rule
    public TestName name = new TestName();

    public File basedir() throws IOException {
        ProtectionDomain protectionDomain = ((Object)((Object)this)).getClass().getProtectionDomain();
        return new File(new File(protectionDomain.getCodeSource().getLocation().getPath()), "../..").getCanonicalFile();
    }

    public String getName() {
        return this.name.getMethodName();
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        String basedir = this.basedir().getPath();
        System.setProperty("javax.net.ssl.trustStore", basedir + "/src/test/resources/client.keystore");
        System.setProperty("javax.net.ssl.trustStorePassword", "password");
        System.setProperty("javax.net.ssl.trustStoreType", "jks");
        System.setProperty("javax.net.ssl.keyStore", basedir + "/src/test/resources/server.keystore");
        System.setProperty("javax.net.ssl.keyStorePassword", "password");
        System.setProperty("javax.net.ssl.keyStoreType", "jks");
        this.exceptions.clear();
        this.startBroker();
        this.createJMSConnection();
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("javax.net.ssl.trustStore");
        System.clearProperty("javax.net.ssl.trustStorePassword");
        System.clearProperty("javax.net.ssl.trustStoreType");
        System.clearProperty("javax.net.ssl.keyStore");
        System.clearProperty("javax.net.ssl.keyStorePassword");
        System.clearProperty("javax.net.ssl.keyStoreType");
        this.stopBroker();
        super.tearDown();
    }

    public void configureBroker() throws Exception {
        super.setUp();
        this.server = this.createServerForMQTT();
        this.addCoreConnector();
        this.addMQTTConnector();
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setMaxSizeBytes(999999999L);
        addressSettings.setAutoCreateQueues(Boolean.valueOf(true));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(true));
        this.configureBrokerSecurity(this.server);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
    }

    protected void configureBrokerSecurity(ActiveMQServer server) {
        if (this.isSecurityEnabled()) {
            ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
            securityManager.getConfiguration().addUser(this.noprivUser, this.noprivPass);
            securityManager.getConfiguration().addRole(this.noprivUser, "nothing");
            securityManager.getConfiguration().addUser(this.browseUser, this.browsePass);
            securityManager.getConfiguration().addRole(this.browseUser, "browser");
            securityManager.getConfiguration().addUser(this.guestUser, this.guestPass);
            securityManager.getConfiguration().addRole(this.guestUser, "guest");
            securityManager.getConfiguration().addUser(this.fullUser, this.fullPass);
            securityManager.getConfiguration().addRole(this.fullUser, "full");
            HierarchicalRepository securityRepository = server.getSecurityRepository();
            HashSet<Role> value = new HashSet<Role>();
            value.add(new Role("nothing", false, false, false, false, false, false, false, false, false, false));
            value.add(new Role("browser", false, false, false, false, false, false, false, true, false, false));
            value.add(new Role("guest", false, true, false, false, false, false, false, true, false, false));
            value.add(new Role("full", true, true, true, true, true, true, true, true, true, true));
            securityRepository.addMatch(this.getQueueName(), value);
            server.getConfiguration().setSecurityEnabled(true);
        } else {
            server.getConfiguration().setSecurityEnabled(false);
        }
    }

    public void startBroker() throws Exception {
        this.configureBroker();
        this.server.start();
        this.server.waitForActivation(10L, TimeUnit.SECONDS);
    }

    public void createJMSConnection() throws Exception {
        this.cf = new ActiveMQConnectionFactory(false, new TransportConfiguration[]{new TransportConfiguration(ActiveMQTestBase.NETTY_CONNECTOR_FACTORY)});
    }

    private ActiveMQServer createServerForMQTT() throws Exception {
        Configuration defaultConfig = this.createDefaultConfig(true).setIncomingInterceptorClassNames(Collections.singletonList(MQTTIncomingInterceptor.class.getName())).setOutgoingInterceptorClassNames(Collections.singletonList(MQTTOutoingInterceptor.class.getName()));
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setDeadLetterAddress(SimpleString.toSimpleString((String)"DLA"));
        addressSettings.setExpiryAddress(SimpleString.toSimpleString((String)"EXPIRY"));
        defaultConfig.getAddressesSettings().put("#", addressSettings);
        return this.createServer(true, defaultConfig);
    }

    protected void addCoreConnector() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("port", "5445");
        params.put("protocols", "CORE");
        TransportConfiguration transportConfiguration = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params);
        this.server.getConfiguration().getAcceptorConfigurations().add(transportConfiguration);
        log.debug((Object)"Added CORE connector to broker");
    }

    protected void addMQTTConnector() throws Exception {
        this.server.getConfiguration().addAcceptorConfiguration("MQTT", "tcp://localhost:" + this.port + "?protocols=MQTT;anycastPrefix=anycast:;multicastPrefix=multicast:");
        log.debug((Object)"Added MQTT connector to broker");
    }

    public void stopBroker() throws Exception {
        if (this.server.isStarted()) {
            this.server.stop();
            this.server = null;
        }
    }

    protected String getQueueName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.name.getMethodName();
    }

    protected String getTopicName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.name.getMethodName();
    }

    protected void initializeConnection(MQTTClientProvider provider) throws Exception {
        if (!this.isUseSSL()) {
            provider.connect("tcp://localhost:" + this.port);
        } else {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            provider.setSslContext(ctx);
            provider.connect("ssl://localhost:" + this.port);
        }
    }

    public String getProtocolScheme() {
        return this.protocolScheme;
    }

    public void setProtocolScheme(String scheme) {
        this.protocolScheme = scheme;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSchedulerSupportEnabled() {
        return false;
    }

    public boolean isSecurityEnabled() {
        return false;
    }

    protected void within(int time, TimeUnit unit, Task task) throws InterruptedException {
        long timeMS = unit.toMillis(time);
        long deadline = System.currentTimeMillis() + timeMS;
        while (true) {
            try {
                task.run();
                return;
            }
            catch (Throwable e) {
                long remaining = deadline - System.currentTimeMillis();
                if (remaining <= 0L) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new RuntimeException(e);
                }
                Thread.sleep(Math.min(timeMS / 10L, remaining));
                continue;
            }
            break;
        }
    }

    protected MQTTClientProvider getMQTTClientProvider() {
        return new FuseMQTTClientProvider();
    }

    protected MQTT createMQTTConnection() throws Exception {
        MQTT client = this.createMQTTConnection(null, false);
        client.setVersion("3.1.1");
        return client;
    }

    protected MQTT createMQTTConnection(String clientId, boolean clean) throws Exception {
        if (this.isUseSSL()) {
            return this.createMQTTSslConnection(clientId, clean);
        }
        return this.createMQTTTcpConnection(clientId, clean);
    }

    private MQTT createMQTTTcpConnection(String clientId, boolean clean) throws Exception {
        MQTT mqtt = new MQTT();
        mqtt.setConnectAttemptsMax(1L);
        mqtt.setReconnectAttemptsMax(0L);
        mqtt.setTracer(this.createTracer());
        mqtt.setVersion("3.1.1");
        if (clientId != null) {
            mqtt.setClientId(clientId);
        }
        mqtt.setCleanSession(clean);
        mqtt.setHost("localhost", this.port);
        return mqtt;
    }

    public Map<String, MQTTSessionState> getSessions() {
        ProtocolManager protocolManager;
        Acceptor acceptor = this.server.getRemotingService().getAcceptor("MQTT");
        if (acceptor instanceof AbstractAcceptor && (protocolManager = (ProtocolManager)((AbstractAcceptor)acceptor).getProtocolMap().get("MQTT")) instanceof MQTTProtocolManager) {
            return ((MQTTProtocolManager)protocolManager).getSessionStates();
        }
        return Collections.emptyMap();
    }

    private MQTT createMQTTSslConnection(String clientId, boolean clean) throws Exception {
        MQTT mqtt = new MQTT();
        mqtt.setConnectAttemptsMax(1L);
        mqtt.setReconnectAttemptsMax(0L);
        mqtt.setTracer(this.createTracer());
        mqtt.setHost("ssl://localhost:" + this.port);
        if (clientId != null) {
            mqtt.setClientId(clientId);
        }
        mqtt.setCleanSession(clean);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        mqtt.setSslContext(ctx);
        return mqtt;
    }

    protected Tracer createTracer() {
        return new Tracer(){

            public void onReceive(MQTTFrame frame) {
                log.debug((Object)("Client Received:\n" + frame));
            }

            public void onSend(MQTTFrame frame) {
                log.debug((Object)("Client Sent:\n" + frame));
            }

            public void debug(String message, Object ... args) {
                log.debug((Object)String.format(message, args));
            }
        };
    }

    static {
        DispatcherConfig.getDefaultDispatcher().getThreadQueues(DispatchPriority.DEFAULT);
    }

    public static class MQTTOutoingInterceptor
    implements MQTTInterceptor {
        private static int messageCount = 0;

        public boolean intercept(MqttMessage packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getClass() == MqttPublishMessage.class) {
                ++messageCount;
            }
            return true;
        }

        public static void clear() {
            messageCount = 0;
        }

        public static int getMessageCount() {
            return messageCount;
        }
    }

    public static class MQTTIncomingInterceptor
    implements MQTTInterceptor {
        private static int messageCount = 0;

        public boolean intercept(MqttMessage packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getClass() == MqttPublishMessage.class) {
                ++messageCount;
            }
            return true;
        }

        public static void clear() {
            messageCount = 0;
        }

        public static int getMessageCount() {
            return messageCount;
        }
    }

    static class DefaultTrustManager
    implements X509TrustManager {
        DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    protected static interface Task {
        public void run() throws Exception;
    }
}

