/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.paging.SpawnedServerSupport;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;

public class PagingWithFailoverServer
extends SpawnedServerSupport {
    private ActiveMQServer server;

    public static Process spawnVM(String testDir, int thisPort, int otherPort) throws Exception {
        return PagingWithFailoverServer.spawnVM(testDir, thisPort, otherPort, false);
    }

    public static Process spawnVM(String testDir, int thisPort, int otherPort, boolean isBackup) throws Exception {
        return SpawnedVMSupport.spawnVM((String)PagingWithFailoverServer.class.getName(), (String[])new String[]{testDir, Integer.toString(thisPort), Integer.toString(otherPort), Boolean.toString(isBackup)});
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    public void perform(String folder, int thisPort, int otherPort, boolean isBackup) throws Exception {
        try {
            this.server = PagingWithFailoverServer.createServer(folder, thisPort, otherPort, isBackup);
            this.server.start();
            System.out.println("Server started!!!");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static ActiveMQServer createServer(String folder, int thisPort, int otherPort, boolean isBackup) {
        return PagingWithFailoverServer.createSharedFolderServer(folder, thisPort, otherPort, isBackup);
    }

    public static void main(String[] arg) {
        if (arg.length != 4) {
            System.out.println("expected folder portThisServer portOtherServer isBackup");
        }
        PagingWithFailoverServer server = new PagingWithFailoverServer();
        try {
            server.perform(arg[0], Integer.parseInt(arg[1]), Integer.parseInt(arg[2]), Boolean.parseBoolean(arg[3]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

