/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics;

import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.wildfly.extension.metrics.MetricID;

public interface MetricMetadata {
    public static final String NONE = "none";

    public String getMetricName();

    public MetricTag[] getTags();

    public String getDescription();

    public MeasurementUnit getMeasurementUnit();

    public Type getType();

    public MetricID getMetricID();

    default public String getBaseMetricUnit() {
        return MetricMetadata.baseMetricUnit(this.getMeasurementUnit());
    }

    public static String baseMetricUnit(MeasurementUnit unit) {
        if (unit == null) {
            return NONE;
        }
        switch (unit.getBaseUnits()) {
            case PERCENTAGE: {
                return "percent";
            }
            case BYTES: 
            case KILOBYTES: 
            case MEGABYTES: 
            case GIGABYTES: 
            case TERABYTES: 
            case PETABYTES: {
                return "bytes";
            }
            case BITS: 
            case KILOBITS: 
            case MEGABITS: 
            case GIGABITS: 
            case TERABITS: 
            case PETABITS: {
                return "bits";
            }
            case EPOCH_MILLISECONDS: 
            case EPOCH_SECONDS: 
            case NANOSECONDS: 
            case MILLISECONDS: 
            case MICROSECONDS: 
            case SECONDS: 
            case MINUTES: 
            case HOURS: 
            case DAYS: {
                return "seconds";
            }
            case JIFFYS: {
                return "jiffys";
            }
            case PER_JIFFY: {
                return "per-jiffy";
            }
            case PER_NANOSECOND: 
            case PER_MICROSECOND: 
            case PER_MILLISECOND: 
            case PER_SECOND: 
            case PER_MINUTE: 
            case PER_HOUR: 
            case PER_DAY: {
                return "per_second";
            }
            case CELSIUS: {
                return "degree_celsius";
            }
            case KELVIN: {
                return "kelvin";
            }
            case FAHRENHEIGHT: {
                return "degree_fahrenheit";
            }
        }
        return NONE;
    }

    public static class MetricTag {
        private String key;
        private String value;

        public MetricTag(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Type {
        COUNTER,
        GAUGE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

