/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.capabilities;

import java.security.Principal;
import java.util.function.Function;
import org.wildfly.common.Assert;

public interface PrincipalTransformer
extends Function<Principal, Principal> {
    public static PrincipalTransformer from(Function<Principal, Principal> function) {
        return function::apply;
    }

    public static PrincipalTransformer aggregate(PrincipalTransformer ... transformers) {
        Assert.checkNotNullParam((String)"transformers", (Object)transformers);
        PrincipalTransformer[] clone = (PrincipalTransformer[])transformers.clone();
        for (int i = 0; i < clone.length; ++i) {
            Assert.checkNotNullArrayParam((String)"transformers", (int)i, (Object)clone[i]);
        }
        return principal -> {
            if (principal == null) {
                return null;
            }
            for (PrincipalTransformer transformer : clone) {
                Principal transformed = (Principal)transformer.apply(principal);
                if (transformed == null) continue;
                return transformed;
            }
            return null;
        };
    }

    public static PrincipalTransformer chain(PrincipalTransformer ... transformers) {
        Assert.checkNotNullParam((String)"transformers", (Object)transformers);
        PrincipalTransformer[] clone = (PrincipalTransformer[])transformers.clone();
        for (int i = 0; i < clone.length; ++i) {
            Assert.checkNotNullArrayParam((String)"transformers", (int)i, (Object)clone[i]);
        }
        return principal -> {
            for (PrincipalTransformer transformer : clone) {
                if (principal == null) {
                    return null;
                }
                principal = (Principal)transformer.apply(principal);
            }
            return principal;
        };
    }
}

