/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.util.ArrayList;
import java.util.Locale;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.State;

public class ConfirmationChoice
implements State {
    private static final String LONG_YES = DomainManagementLogger.ROOT_LOGGER.yes().toLowerCase(Locale.getDefault());
    private static final String LONG_NO = DomainManagementLogger.ROOT_LOGGER.no().toLowerCase(Locale.getDefault());
    private static final String SHORT_YES = DomainManagementLogger.ROOT_LOGGER.shortYes().toLowerCase(Locale.getDefault());
    private static final String SHORT_NO = DomainManagementLogger.ROOT_LOGGER.shortNo().toLowerCase(Locale.getDefault());
    private ConsoleWrapper theConsole;
    private final String[] messageLines;
    private final String prompt;
    private final State yesState;
    private final State noState;
    private static final int YES = 0;
    private static final int NO = 1;
    private static final int INVALID = 2;

    public ConfirmationChoice(ConsoleWrapper theConsole, String[] messageLines, String prompt, State yesState, State noState) {
        this.theConsole = theConsole;
        this.messageLines = messageLines;
        this.prompt = prompt;
        this.yesState = yesState;
        this.noState = noState;
    }

    public ConfirmationChoice(ConsoleWrapper theConsole, String message, String prompt, State yesState, State noState) {
        this(theConsole, new String[]{message}, prompt, yesState, noState);
    }

    @Override
    public State execute() {
        if (this.messageLines != null) {
            for (String message : this.messageLines) {
                this.theConsole.printf(message, new Object[0]);
                this.theConsole.printf(AddUser.NEW_LINE, new Object[0]);
            }
        }
        this.theConsole.printf(this.prompt, new Object[0]);
        String temp = this.theConsole.readLine(" ", new Object[0]);
        switch (this.convertResponse(temp)) {
            case 0: {
                return this.yesState;
            }
            case 1: {
                return this.noState;
            }
        }
        ArrayList<String> acceptedValues = new ArrayList<String>(4);
        acceptedValues.add(DomainManagementLogger.ROOT_LOGGER.yes());
        if (DomainManagementLogger.ROOT_LOGGER.shortYes().length() > 0) {
            acceptedValues.add(DomainManagementLogger.ROOT_LOGGER.shortYes());
        }
        acceptedValues.add(DomainManagementLogger.ROOT_LOGGER.no());
        if (DomainManagementLogger.ROOT_LOGGER.shortNo().length() > 0) {
            acceptedValues.add(DomainManagementLogger.ROOT_LOGGER.shortNo());
        }
        StringBuilder sb = new StringBuilder((String)acceptedValues.get(0));
        for (int i = 1; i < acceptedValues.size() - 1; ++i) {
            sb.append(", ");
            sb.append((String)acceptedValues.get(i));
        }
        return new ErrorState(this.theConsole, DomainManagementLogger.ROOT_LOGGER.invalidConfirmationResponse(sb.toString(), (String)acceptedValues.get(acceptedValues.size() - 1)), this);
    }

    private int convertResponse(String response) {
        if (response != null) {
            String temp = response.toLowerCase();
            if (LONG_YES.equals(temp) || SHORT_YES.equals(temp)) {
                return 0;
            }
            if (LONG_NO.equals(temp) || SHORT_NO.equals(temp)) {
                return 1;
            }
        }
        return 2;
    }
}

