/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.jboss.resteasy.annotations.providers.img.ImageWriterParams;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.util.FindAnnotation;

public final class IIOImageProviderHelper {
    private IIOImageProviderHelper() {
    }

    public static ImageWriter getImageWriterByMediaType(MediaType mediaType) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(mediaType.toString());
        ImageWriter writer = writers.next();
        if (writer == null) {
            Response response = Response.serverError().entity((Object)"").build();
            throw new WebApplicationException(response);
        }
        return writer;
    }

    public static IIOImage readImage(InputStream in, ImageReader reader, int imageIndex) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(in);
        reader.setInput(iis, false);
        return reader.readAll(imageIndex, null);
    }

    public static ImageReader getImageReaderByMediaType(MediaType mediaType) {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByMIMEType(mediaType.toString());
        ImageReader reader = null;
        while (readers.hasNext()) {
            reader = readers.next();
        }
        if (reader == null) {
            String[] availableTypes = ImageIO.getReaderMIMETypes();
            LogMessages.LOGGER.readerNotFound(mediaType, availableTypes);
            List<Variant> variants = ProviderHelper.getAvailableVariants(availableTypes);
            Response response = Response.notAcceptable(variants).status(Response.Status.NOT_ACCEPTABLE).build();
            throw new WebApplicationException(response);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImage(Annotation[] annotations, MediaType mediaType, ImageWriter writer, OutputStream out, IIOImage image) throws IOException {
        ImageWriteParam param = mediaType.equals((Object)MediaType.valueOf((String)"image/jpeg")) ? new JPEGImageWriteParam(Locale.US) : writer.getDefaultWriteParam();
        ImageWriterParams writerParams = (ImageWriterParams)FindAnnotation.findAnnotation((Annotation[])annotations, ImageWriterParams.class);
        if (writerParams != null) {
            if (param.canWriteCompressed()) {
                param.setCompressionMode(writerParams.compressionMode());
                param.setCompressionQuality(writerParams.compressionQuality());
            }
        } else if (param.canWriteCompressed()) {
            param.setCompressionMode(2);
            param.setCompressionQuality(1.0f);
        }
        BufferedOutputStream buff = new BufferedOutputStream(out, 2048);
        ImageOutputStream ios = ImageIO.createImageOutputStream(buff);
        try {
            writer.setOutput(ios);
            writer.write(null, image, param);
        }
        finally {
            writer.dispose();
        }
    }
}

