/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.tree.insert.InsertStatement;

public class BulkOperationCleanupAction
implements Executable,
Serializable {
    private final Serializable[] affectedTableSpaces;
    private final Set<EntityCleanup> entityCleanups = new HashSet<EntityCleanup>();
    private final Set<CollectionCleanup> collectionCleanups = new HashSet<CollectionCleanup>();
    private final Set<NaturalIdCleanup> naturalIdCleanups = new HashSet<NaturalIdCleanup>();

    public BulkOperationCleanupAction(SharedSessionContractImplementor session, EntityPersister ... affectedQueryables) {
        SessionFactoryImplementor factory = session.getFactory();
        LinkedHashSet spacesList = new LinkedHashSet();
        for (EntityPersister persister : affectedQueryables) {
            MappingMetamodelImplementor mappingMetamodel;
            Set<String> roles;
            EntityDataAccess entityDataAccess;
            Collections.addAll(spacesList, (String[])persister.getQuerySpaces());
            if (persister.canWriteToCache() && (entityDataAccess = persister.getCacheAccessStrategy()) != null) {
                this.entityCleanups.add(new EntityCleanup(entityDataAccess, session));
            }
            if (persister.hasNaturalIdentifier() && persister.hasNaturalIdCache()) {
                this.naturalIdCleanups.add(new NaturalIdCleanup(persister.getNaturalIdCacheAccessStrategy(), session));
            }
            if ((roles = (mappingMetamodel = factory.getRuntimeMetamodels().getMappingMetamodel()).getCollectionRolesByEntityParticipant(persister.getEntityName())) == null) continue;
            for (String role : roles) {
                CollectionPersister collectionPersister = mappingMetamodel.getCollectionDescriptor(role);
                if (!collectionPersister.hasCache()) continue;
                this.collectionCleanups.add(new CollectionCleanup(collectionPersister.getCacheAccessStrategy(), session));
            }
        }
        this.affectedTableSpaces = (Serializable[])spacesList.toArray(new String[0]);
    }

    public BulkOperationCleanupAction(SharedSessionContractImplementor session, Set<String> tableSpaces) {
        LinkedHashSet<String> spacesList = new LinkedHashSet<String>(tableSpaces);
        SessionFactoryImplementor factory = session.getFactory();
        MappingMetamodelImplementor metamodel = factory.getRuntimeMetamodels().getMappingMetamodel();
        metamodel.forEachEntityDescriptor(entityDescriptor -> {
            String[] entitySpaces = (String[])entityDescriptor.getQuerySpaces();
            if (this.affectedEntity(tableSpaces, (Serializable[])entitySpaces)) {
                Set<String> roles;
                Collections.addAll(spacesList, entitySpaces);
                if (entityDescriptor.canWriteToCache()) {
                    this.entityCleanups.add(new EntityCleanup(entityDescriptor.getCacheAccessStrategy(), session));
                }
                if (entityDescriptor.hasNaturalIdentifier() && entityDescriptor.hasNaturalIdCache()) {
                    this.naturalIdCleanups.add(new NaturalIdCleanup(entityDescriptor.getNaturalIdCacheAccessStrategy(), session));
                }
                if ((roles = metamodel.getCollectionRolesByEntityParticipant(entityDescriptor.getEntityName())) != null) {
                    for (String role : roles) {
                        CollectionPersister collectionDescriptor = metamodel.getCollectionDescriptor(role);
                        if (!collectionDescriptor.hasCache()) continue;
                        this.collectionCleanups.add(new CollectionCleanup(collectionDescriptor.getCacheAccessStrategy(), session));
                    }
                }
            }
        });
        this.affectedTableSpaces = (Serializable[])spacesList.toArray(new String[0]);
    }

    public static void schedule(SharedSessionContractImplementor session, SqmDmlStatement<?> statement) {
        ArrayList<EntityPersister> entityPersisters = new ArrayList<EntityPersister>(1);
        MappingMetamodelImplementor metamodel = session.getFactory().getRuntimeMetamodels().getMappingMetamodel();
        if (!(statement instanceof InsertStatement)) {
            entityPersisters.add(metamodel.getEntityDescriptor(((SqmRoot)statement.getTarget()).getEntityName()));
        }
        for (SqmCteStatement cteStatement : statement.getCteStatements()) {
            SqmStatement<?> cteDefinition = cteStatement.getCteDefinition();
            if (!(cteDefinition instanceof SqmDmlStatement) || cteDefinition instanceof InsertStatement) continue;
            entityPersisters.add(metamodel.getEntityDescriptor(((SqmRoot)((SqmDmlStatement)cteDefinition).getTarget()).getEntityName()));
        }
        BulkOperationCleanupAction.schedule(session, entityPersisters.toArray(new EntityPersister[0]));
    }

    public static void schedule(SharedSessionContractImplementor session, EntityPersister ... affectedQueryables) {
        BulkOperationCleanupAction action = new BulkOperationCleanupAction(session, affectedQueryables);
        if (session.isEventSource()) {
            ((EventSource)session).getActionQueue().addAction(action);
        } else {
            action.getAfterTransactionCompletionProcess().doAfterTransactionCompletion(true, session);
        }
    }

    public static void schedule(SharedSessionContractImplementor session, Set<String> affectedQueryables) {
        BulkOperationCleanupAction action = new BulkOperationCleanupAction(session, affectedQueryables);
        if (session.isEventSource()) {
            ((EventSource)session).getActionQueue().addAction(action);
        } else {
            action.getAfterTransactionCompletionProcess().doAfterTransactionCompletion(true, session);
        }
    }

    private boolean affectedEntity(Set<?> affectedTableSpaces, Serializable[] checkTableSpaces) {
        if (affectedTableSpaces == null || affectedTableSpaces.isEmpty()) {
            return true;
        }
        for (Serializable checkTableSpace : checkTableSpaces) {
            if (!affectedTableSpaces.contains(checkTableSpace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Serializable[] getPropertySpaces() {
        return this.affectedTableSpaces;
    }

    @Override
    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    @Override
    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return (success, session) -> {
            for (EntityCleanup entityCleanup : this.entityCleanups) {
                entityCleanup.release();
            }
            this.entityCleanups.clear();
            for (NaturalIdCleanup naturalIdCleanup : this.naturalIdCleanups) {
                naturalIdCleanup.release();
            }
            this.naturalIdCleanups.clear();
            for (CollectionCleanup collectionCleanup : this.collectionCleanups) {
                collectionCleanup.release();
            }
            this.collectionCleanups.clear();
        };
    }

    @Override
    public void beforeExecutions() throws HibernateException {
    }

    @Override
    public void execute() throws HibernateException {
    }

    @Override
    public void afterDeserialize(SharedSessionContractImplementor session) {
    }

    private static class NaturalIdCleanup
    implements Serializable {
        private final NaturalIdDataAccess naturalIdCacheAccessStrategy;
        private final SoftLock cacheLock;

        public NaturalIdCleanup(NaturalIdDataAccess naturalIdCacheAccessStrategy, SharedSessionContractImplementor session) {
            this.naturalIdCacheAccessStrategy = naturalIdCacheAccessStrategy;
            this.cacheLock = naturalIdCacheAccessStrategy.lockRegion();
            naturalIdCacheAccessStrategy.removeAll(session);
        }

        private void release() {
            this.naturalIdCacheAccessStrategy.unlockRegion(this.cacheLock);
        }
    }

    private static class CollectionCleanup
    implements Serializable {
        private final CollectionDataAccess cacheAccess;
        private final SoftLock cacheLock;

        private CollectionCleanup(CollectionDataAccess cacheAccess, SharedSessionContractImplementor session) {
            this.cacheAccess = cacheAccess;
            this.cacheLock = cacheAccess.lockRegion();
            cacheAccess.removeAll(session);
        }

        private void release() {
            this.cacheAccess.unlockRegion(this.cacheLock);
        }
    }

    private static class EntityCleanup
    implements Serializable {
        private final EntityDataAccess cacheAccess;
        private final SoftLock cacheLock;

        private EntityCleanup(EntityDataAccess cacheAccess, SharedSessionContractImplementor session) {
            this.cacheAccess = cacheAccess;
            this.cacheLock = cacheAccess.lockRegion();
            cacheAccess.removeAll(session);
        }

        private void release() {
            this.cacheAccess.unlockRegion(this.cacheLock);
        }
    }
}

