/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.EntityState;
import org.hibernate.event.internal.EventUtil;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EntityCopyObserver;
import org.hibernate.event.spi.EntityCopyObserverFactory;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeContext;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.TypeHelper;

public class DefaultMergeEventListener
extends AbstractSaveEventListener<MergeContext>
implements MergeEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultMergeEventListener.class);

    @Override
    protected Map<Object, Object> getMergeMap(MergeContext context) {
        return context.invertMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMerge(MergeEvent event) throws HibernateException {
        EntityCopyObserver entityCopyObserver = this.createEntityCopyObserver(event.getSession().getFactory());
        MergeContext mergeContext = new MergeContext(event.getSession(), entityCopyObserver);
        try {
            this.onMerge(event, mergeContext);
            entityCopyObserver.topLevelMergeComplete(event.getSession());
        }
        finally {
            entityCopyObserver.clear();
            mergeContext.clear();
        }
    }

    private EntityCopyObserver createEntityCopyObserver(SessionFactoryImplementor sessionFactory) {
        return sessionFactory.getServiceRegistry().getService(EntityCopyObserverFactory.class).createEntityCopyObserver();
    }

    @Override
    public void onMerge(MergeEvent event, MergeContext copiedAlready) throws HibernateException {
        EventSource source = event.getSession();
        Object original = event.getOriginal();
        if (original != null) {
            Object entity;
            if (original instanceof HibernateProxy) {
                LazyInitializer li = ((HibernateProxy)original).getHibernateLazyInitializer();
                if (li.isUninitialized()) {
                    LOG.trace("Ignoring uninitialized proxy");
                    event.setResult(source.load(li.getEntityName(), li.getInternalIdentifier()));
                    return;
                }
                entity = li.getImplementation();
            } else if (original instanceof PersistentAttributeInterceptable) {
                PersistentAttributeInterceptable interceptable = (PersistentAttributeInterceptable)original;
                PersistentAttributeInterceptor interceptor = interceptable.$$_hibernate_getInterceptor();
                if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                    EnhancementAsProxyLazinessInterceptor proxyInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                    LOG.trace("Ignoring uninitialized enhanced-proxy");
                    event.setResult(source.load(proxyInterceptor.getEntityName(), proxyInterceptor.getIdentifier()));
                    return;
                }
                entity = original;
            } else {
                entity = original;
            }
            if (copiedAlready.containsKey(entity) && copiedAlready.isOperatedOn(entity)) {
                LOG.trace("Already in merge process");
                event.setResult(entity);
            } else {
                EntityKey key;
                Object managedEntity;
                EntityPersister persister;
                Object id;
                if (copiedAlready.containsKey(entity)) {
                    LOG.trace("Already in copyCache; setting in merge process");
                    copiedAlready.setOperatedOn(entity, true);
                }
                event.setEntity(entity);
                Enum entityState = null;
                PersistenceContext persistenceContext = source.getPersistenceContextInternal();
                EntityEntry entry = persistenceContext.getEntry(entity);
                if (entry == null && (id = (persister = source.getEntityPersister(event.getEntityName(), entity)).getIdentifier(entity, source)) != null && (entry = persistenceContext.getEntry(managedEntity = persistenceContext.getEntity(key = source.generateEntityKey(id, persister)))) != null) {
                    entityState = EntityState.DETACHED;
                }
                if (entityState == null) {
                    entityState = EntityState.getEntityState(entity, event.getEntityName(), entry, source, false);
                }
                switch (1.$SwitchMap$org$hibernate$event$internal$EntityState[entityState.ordinal()]) {
                    case 1: {
                        this.entityIsDetached(event, copiedAlready);
                        break;
                    }
                    case 2: {
                        this.entityIsTransient(event, copiedAlready);
                        break;
                    }
                    case 3: {
                        this.entityIsPersistent(event, copiedAlready);
                        break;
                    }
                    default: {
                        throw new ObjectDeletedException("deleted instance passed to merge", null, EventUtil.getLoggableName(event.getEntityName(), entity));
                    }
                }
            }
        }
    }

    protected void entityIsPersistent(MergeEvent event, MergeContext copyCache) {
        LOG.trace("Ignoring persistent instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        copyCache.put(entity, entity, true);
        this.cascadeOnMerge(source, persister, entity, copyCache);
        this.copyValues(persister, entity, entity, source, copyCache);
        event.setResult(entity);
    }

    protected void entityIsTransient(MergeEvent event, MergeContext copyCache) {
        PersistentAttributeInterceptable interceptable;
        PersistentAttributeInterceptor interceptor;
        Object copy;
        LOG.trace("Merging transient instance");
        Object entity = event.getEntity();
        EventSource session = event.getSession();
        String entityName = event.getEntityName();
        EntityPersister persister = session.getEntityPersister(entityName, entity);
        Object id = persister.hasIdentifierProperty() ? persister.getIdentifier(entity, session) : null;
        Object existingCopy = copyCache.get(entity);
        if (existingCopy != null) {
            persister.setIdentifier(copyCache.get(entity), id, session);
            copy = existingCopy;
        } else {
            copy = session.instantiate(persister, id);
            copyCache.put(entity, copy, true);
        }
        super.cascadeBeforeSave(session, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, session, copyCache, ForeignKeyDirection.FROM_PARENT);
        this.saveTransientEntity(copy, entityName, event.getRequestedId(), session, copyCache);
        super.cascadeAfterSave(session, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, session, copyCache, ForeignKeyDirection.TO_PARENT);
        new CollectionVisitor(copy, id, session).processEntityPropertyValues(persister.getPropertyValuesToInsert(copy, this.getMergeMap(copyCache), session), persister.getPropertyTypes());
        event.setResult(copy);
        if (copy instanceof PersistentAttributeInterceptable && (interceptor = (interceptable = (PersistentAttributeInterceptable)copy).$$_hibernate_getInterceptor()) == null) {
            persister.getBytecodeEnhancementMetadata().injectInterceptor(copy, id, (SharedSessionContractImplementor)session);
        }
    }

    private void saveTransientEntity(Object entity, String entityName, Object requestedId, EventSource source, MergeContext copyCache) {
        if (requestedId == null) {
            this.saveWithGeneratedId(entity, entityName, copyCache, source, false);
        } else {
            this.saveWithRequestedId(entity, requestedId, entityName, copyCache, source);
        }
    }

    protected void entityIsDetached(MergeEvent event, MergeContext copyCache) {
        LOG.trace("Merging detached instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        Object id = event.getRequestedId();
        if (id == null) {
            id = persister.getIdentifier(entity, source);
        } else {
            Object entityId = persister.getIdentifier(entity, source);
            if (!persister.getIdentifierType().isEqual(id, entityId, source.getFactory())) {
                throw new HibernateException("merge requested with id not matching id of passed entity");
            }
        }
        Object clonedIdentifier = persister.getIdentifierType().deepCopy(id, source.getFactory());
        Object result = source.getLoadQueryInfluencers().fromInternalFetchProfile(CascadingFetchProfile.MERGE, () -> source.get(entityName, clonedIdentifier));
        if (result == null) {
            this.entityIsTransient(event, copyCache);
        } else {
            copyCache.put(entity, result, true);
            Object target = this.unproxyManagedForDetachedMerging(entity, result, persister, source);
            if (target == entity) {
                throw new AssertionFailure("entity was not detached");
            }
            if (!source.getEntityName(target).equals(entityName)) {
                throw new WrongClassException("class of the given object did not match class of persistent copy", event.getRequestedId(), entityName);
            }
            if (this.isVersionChanged(entity, source, persister, target)) {
                StatisticsImplementor statistics = source.getFactory().getStatistics();
                if (statistics.isStatisticsEnabled()) {
                    statistics.optimisticFailure(entityName);
                }
                throw new StaleObjectStateException(entityName, id);
            }
            this.cascadeOnMerge(source, persister, entity, copyCache);
            this.copyValues(persister, entity, target, source, copyCache);
            this.markInterceptorDirty(entity, target);
            event.setResult(result);
        }
    }

    private Object unproxyManagedForDetachedMerging(Object incoming, Object managed, EntityPersister persister, EventSource source) {
        if (managed instanceof HibernateProxy) {
            return source.getPersistenceContextInternal().unproxy(managed);
        }
        if (incoming instanceof PersistentAttributeInterceptable && persister.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
            PersistentAttributeInterceptor incomingInterceptor = ((PersistentAttributeInterceptable)incoming).$$_hibernate_getInterceptor();
            PersistentAttributeInterceptor managedInterceptor = ((PersistentAttributeInterceptable)managed).$$_hibernate_getInterceptor();
            if (!(managedInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
                return managed;
            }
            if (incomingInterceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                return managed;
            }
            persister.initializeEnhancedEntityUsedAsProxy(managed, null, source);
        }
        return managed;
    }

    private void markInterceptorDirty(Object entity, Object target) {
        if (entity instanceof SelfDirtinessTracker && target instanceof SelfDirtinessTracker) {
            ((SelfDirtinessTracker)target).$$_hibernate_clearDirtyAttributes();
            for (String fieldName : ((SelfDirtinessTracker)entity).$$_hibernate_getDirtyAttributes()) {
                ((SelfDirtinessTracker)target).$$_hibernate_trackChange(fieldName);
            }
        }
    }

    private boolean isVersionChanged(Object entity, EventSource source, EntityPersister persister, Object target) {
        if (!persister.isVersioned()) {
            return false;
        }
        boolean changed = !persister.getVersionType().isSame(persister.getVersion(target), persister.getVersion(entity));
        return changed && this.existsInDatabase(target, source, persister);
    }

    private boolean existsInDatabase(Object entity, EventSource source, EntityPersister persister) {
        Object id;
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        if (entry == null && (id = persister.getIdentifier(entity, source)) != null) {
            EntityKey key = source.generateEntityKey(id, persister);
            Object managedEntity = persistenceContext.getEntity(key);
            entry = persistenceContext.getEntry(managedEntity);
        }
        return entry != null && entry.isExistsInDatabase();
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, MergeContext copyCache) {
        Object[] copiedValues = TypeHelper.replace(persister.getValues(entity), persister.getValues(target), persister.getPropertyTypes(), source, target, copyCache);
        persister.setValues(target, copiedValues);
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, MergeContext copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copiedValues = foreignKeyDirection == ForeignKeyDirection.TO_PARENT ? TypeHelper.replaceAssociations(persister.getValues(entity), persister.getValues(target), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection) : TypeHelper.replace(persister.getValues(entity), persister.getValues(target), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection);
        persister.setValues(target, copiedValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeOnMerge(EventSource source, EntityPersister persister, Object entity, MergeContext copyCache) {
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        persistenceContext.incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.BEFORE_MERGE, source, persister, entity, copyCache);
        }
        finally {
            persistenceContext.decrementCascadeLevel();
        }
    }

    @Override
    protected CascadingAction<MergeContext> getCascadeAction() {
        return CascadingActions.MERGE;
    }

    @Override
    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, MergeContext anything) throws HibernateException {
    }

    @Override
    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, MergeContext anything) throws HibernateException {
    }

    private class CollectionVisitor
    extends WrapVisitor {
        CollectionVisitor(Object entity, Object id, EventSource session) {
            super(entity, id, session);
        }

        @Override
        Object processCollection(Object collection, CollectionType collectionType) throws HibernateException {
            if (collection instanceof PersistentCollection) {
                PersistentCollection coll = (PersistentCollection)collection;
                CollectionPersister persister = this.getSession().getFactory().getRuntimeMetamodels().getMappingMetamodel().getCollectionDescriptor(collectionType.getRole());
                CollectionEntry collectionEntry = this.getSession().getPersistenceContextInternal().getCollectionEntries().get(coll);
                if (!coll.equalsSnapshot(persister)) {
                    collectionEntry.resetStoredSnapshot(coll, coll.getSnapshot(persister));
                }
            }
            return null;
        }

        @Override
        Object processEntity(Object value, EntityType entityType) throws HibernateException {
            return null;
        }
    }
}

