/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ConvertibleModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicValuedCollectionPart
implements CollectionPart,
BasicValuedModelPart,
ConvertibleModelPart,
FetchOptions {
    private final NavigableRole navigableRole;
    private final CollectionPersister collectionDescriptor;
    private final CollectionPart.Nature nature;
    private final BasicValueConverter<Object, ?> valueConverter;
    private final SelectableMapping selectableMapping;

    public BasicValuedCollectionPart(CollectionPersister collectionDescriptor, CollectionPart.Nature nature, BasicValueConverter valueConverter, SelectableMapping selectableMapping) {
        this.navigableRole = collectionDescriptor.getNavigableRole().append(nature.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.nature = nature;
        this.valueConverter = valueConverter;
        this.selectableMapping = selectableMapping;
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.selectableMapping.getJdbcMapping()::getJavaTypeDescriptor;
    }

    @Override
    public String getContainingTableExpression() {
        return this.selectableMapping.getContainingTableExpression();
    }

    @Override
    public String getSelectionExpression() {
        return this.selectableMapping.getSelectionExpression();
    }

    @Override
    public boolean isFormula() {
        return this.selectableMapping.isFormula();
    }

    @Override
    public String getCustomReadExpression() {
        return this.selectableMapping.getCustomReadExpression();
    }

    @Override
    public String getCustomWriteExpression() {
        return this.selectableMapping.getCustomWriteExpression();
    }

    @Override
    public String getColumnDefinition() {
        return this.selectableMapping.getColumnDefinition();
    }

    @Override
    public Long getLength() {
        return this.selectableMapping.getLength();
    }

    @Override
    public Integer getPrecision() {
        return this.selectableMapping.getPrecision();
    }

    @Override
    public Integer getScale() {
        return this.selectableMapping.getScale();
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.selectableMapping.getJdbcMapping().getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    public String toString() {
        return "BasicValuedCollectionPart(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, tableGroup, true, null, creationState);
        return new BasicResult<Object>(sqlSelection.getValuesArrayPosition(), resultVariable, this.getJavaType(), this.valueConverter, navigablePath);
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, TableGroup tableGroup, boolean allowFkOptimization, FetchParent fetchParent, DomainResultCreationState creationState) {
        SqlExpressionResolver exprResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        TableGroup targetTableGroup = this.nature == CollectionPart.Nature.INDEX && this.collectionDescriptor.getAttributeMapping().getIndexMetadata().getIndexPropertyName() != null ? ((PluralTableGroup)tableGroup).getElementTableGroup() : tableGroup;
        TableReference tableReference = targetTableGroup.resolveTableReference(navigablePath, this.getContainingTableExpression(), allowFkOptimization);
        return exprResolver.resolveSqlSelection(exprResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.selectableMapping.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableReference, this.selectableMapping, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), this.getJavaType(), fetchParent, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, tableGroup, true, null, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(navigablePath, tableGroup, true, null, creationState), this.getJdbcMapping());
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.selectableMapping.getJdbcMapping();
    }

    @Override
    public MappingType getMappedType() {
        return this::getJavaType;
    }

    @Override
    public String getFetchableName() {
        return this.nature.getName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        ResultsLogger.RESULTS_LOGGER.debugf("Generating Fetch for collection-part : `%s` -> `%s`", (Object)this.collectionDescriptor.getRole(), (Object)this.nature.getName());
        NavigablePath parentNavigablePath = fetchablePath.getParent();
        if (parentNavigablePath instanceof EntityIdentifierNavigablePath) {
            parentNavigablePath = parentNavigablePath.getParent();
        }
        TableGroup tableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(parentNavigablePath);
        SqlSelection sqlSelection = this.resolveSqlSelection(fetchablePath, tableGroup, true, fetchParent, creationState);
        return new BasicFetch<Object>(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, this.valueConverter, FetchTiming.IMMEDIATE, creationState);
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return Collections.singletonList(this.getJdbcMapping());
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.selectableMapping.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this.selectableMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (this.valueConverter != null) {
            return this.valueConverter.toRelationalValue(value);
        }
        return value;
    }
}

