/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.model.domain.AnyMappingDomainType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.query.BindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.spi.NavigablePath;

public class AnyMappingSqmPathSource<J>
extends AbstractSqmPathSource<J>
implements BindableType<J> {
    private final SqmPathSource<?> keyPathSource;

    public AnyMappingSqmPathSource(String localPathName, AnyMappingDomainType<J> domainType, Bindable.BindableType jpaBindableType) {
        super(localPathName, domainType, jpaBindableType);
        this.keyPathSource = new BasicSqmPathSource("id", (BasicDomainType)domainType.getKeyType(), Bindable.BindableType.SINGULAR_ATTRIBUTE);
    }

    @Override
    public AnyMappingDomainType<J> getSqmPathType() {
        return (AnyMappingDomainType)super.getSqmPathType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        if ("id".equals(name)) {
            return this.keyPathSource;
        }
        throw new UnsupportedMappingException("De-referencing parts of an ANY mapping, other than the key, is not supported");
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        NavigablePath navigablePath = intermediatePathSource == null ? lhs.getNavigablePath().append(this.getPathName()) : lhs.getNavigablePath().append(intermediatePathSource.getPathName()).append(this.getPathName());
        return new SqmAnyValuedSimplePath(navigablePath, this, lhs, lhs.nodeBuilder());
    }
}

