/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import java.util.IdentityHashMap;

public interface SqmCopyContext {
    public <T> T getCopy(T var1);

    public <T> T registerCopy(T var1, T var2);

    public static SqmCopyContext simpleContext() {
        final IdentityHashMap map = new IdentityHashMap();
        return new SqmCopyContext(){

            @Override
            public <T> T getCopy(T original) {
                return (T)map.get(original);
            }

            @Override
            public <T> T registerCopy(T original, T copy) {
                T old = map.put(original, copy);
                if (old != null) {
                    throw new IllegalArgumentException("Already registered a copy: " + old);
                }
                return copy;
            }
        };
    }
}

