/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.query.sqm.FrameMode;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;

public class SqmOver<T>
extends AbstractSqmExpression<T> {
    private final SqmExpression<T> expression;
    private final List<SqmExpression<?>> partitions;
    private final List<SqmSortSpecification> orderList;
    private final FrameMode mode;
    private final FrameKind startKind;
    private final SqmExpression<?> startExpression;
    private final FrameKind endKind;
    private final SqmExpression<?> endExpression;
    private final FrameExclusion exclusion;

    public SqmOver(SqmExpression<T> expression, List<SqmExpression<?>> partitions, List<SqmSortSpecification> orderList, FrameMode mode, FrameKind startKind, SqmExpression<?> startExpression, FrameKind endKind, SqmExpression<?> endExpression, FrameExclusion exclusion) {
        super(expression.getNodeType(), expression.nodeBuilder());
        this.expression = expression;
        this.partitions = partitions;
        this.orderList = orderList;
        this.mode = mode;
        this.startKind = startKind;
        this.startExpression = startExpression;
        this.endKind = endKind;
        this.endExpression = endExpression;
        this.exclusion = exclusion;
    }

    @Override
    public SqmOver<T> copy(SqmCopyContext context) {
        SqmOver existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList partitions = new ArrayList(this.partitions.size());
        for (SqmExpression<?> sqmExpression : this.partitions) {
            partitions.add((SqmExpression<?>)sqmExpression.copy(context));
        }
        ArrayList<SqmSortSpecification> orderList = new ArrayList<SqmSortSpecification>(this.orderList.size());
        for (SqmSortSpecification sortSpecification : this.orderList) {
            orderList.add(sortSpecification.copy(context));
        }
        SqmOver<T> sqmOver = context.registerCopy(this, new SqmOver<T>(this.expression.copy(context), partitions, (List<SqmSortSpecification>)orderList, this.mode, this.startKind, (SqmExpression<?>)(this.startExpression == null ? null : this.startExpression.copy(context)), this.endKind, (SqmExpression<?>)(this.endExpression == null ? null : this.endExpression.copy(context)), this.exclusion));
        this.copyTo(sqmOver, context);
        return sqmOver;
    }

    public SqmExpression<T> getExpression() {
        return this.expression;
    }

    public List<SqmExpression<?>> getPartitions() {
        return this.partitions;
    }

    public List<SqmSortSpecification> getOrderList() {
        return this.orderList;
    }

    public SqmExpression<?> getStartExpression() {
        return this.startExpression;
    }

    public SqmExpression<?> getEndExpression() {
        return this.endExpression;
    }

    public FrameMode getMode() {
        return this.mode;
    }

    public FrameKind getStartKind() {
        return this.startKind;
    }

    public FrameKind getEndKind() {
        return this.endKind;
    }

    public FrameExclusion getExclusion() {
        return this.exclusion;
    }

    @Override
    public SqmExpressible<T> getNodeType() {
        return this.expression.getNodeType();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitOver(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        int i;
        this.expression.appendHqlString(sb);
        sb.append(" over (");
        boolean needsWhitespace = false;
        if (!this.partitions.isEmpty()) {
            needsWhitespace = true;
            sb.append("partition by ");
            this.partitions.get(0).appendHqlString(sb);
            for (i = 1; i < this.partitions.size(); ++i) {
                sb.append(',');
                this.partitions.get(i).appendHqlString(sb);
            }
        }
        if (!this.orderList.isEmpty()) {
            if (needsWhitespace) {
                sb.append(' ');
            }
            needsWhitespace = true;
            sb.append("order by ");
            this.orderList.get(0).appendHqlString(sb);
            for (i = 1; i < this.orderList.size(); ++i) {
                sb.append(',');
                this.orderList.get(i).appendHqlString(sb);
            }
        }
        if (this.mode != FrameMode.ROWS || this.startKind != FrameKind.UNBOUNDED_PRECEDING || this.endKind != FrameKind.CURRENT_ROW || this.exclusion != FrameExclusion.NO_OTHERS) {
            if (needsWhitespace) {
                sb.append(' ');
            }
            switch (this.mode) {
                case GROUPS: {
                    sb.append("groups ");
                    break;
                }
                case RANGE: {
                    sb.append("range ");
                    break;
                }
                case ROWS: {
                    sb.append("rows ");
                }
            }
            if (this.endKind == FrameKind.CURRENT_ROW) {
                SqmOver.renderFrameKind(sb, this.startKind, this.startExpression);
            } else {
                sb.append("between ");
                SqmOver.renderFrameKind(sb, this.startKind, this.startExpression);
                sb.append(" and ");
                SqmOver.renderFrameKind(sb, this.endKind, this.endExpression);
            }
            switch (this.exclusion) {
                case TIES: {
                    sb.append(" exclude ties");
                    break;
                }
                case CURRENT_ROW: {
                    sb.append(" exclude current row");
                    break;
                }
                case GROUP: {
                    sb.append(" exclude group");
                }
            }
        }
        sb.append(')');
    }

    private static void renderFrameKind(StringBuilder sb, FrameKind kind, SqmExpression<?> expression) {
        switch (kind) {
            case CURRENT_ROW: {
                sb.append("current row");
                break;
            }
            case UNBOUNDED_PRECEDING: {
                sb.append("unbounded preceding");
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                sb.append("unbounded following");
                break;
            }
            case OFFSET_PRECEDING: {
                expression.appendHqlString(sb);
                sb.append(" preceding");
                break;
            }
            case OFFSET_FOLLOWING: {
                expression.appendHqlString(sb);
                sb.append(" following");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported frame kind: " + kind);
            }
        }
    }
}

