/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;

public class ConvertedQueryLiteral<D, R>
implements Literal,
DomainResultProducer<D> {
    private final D domainLiteralValue;
    private final R relationalLiteralValue;
    private final BasicValueConverter<D, R> converter;
    private final BasicValuedMapping relationalMapping;

    public ConvertedQueryLiteral(D domainLiteralValue, BasicValueConverter<D, R> converter, BasicValuedMapping relationalMapping) {
        this.domainLiteralValue = domainLiteralValue;
        this.converter = converter;
        this.relationalMapping = relationalMapping;
        this.relationalLiteralValue = converter.toRelationalValue(domainLiteralValue);
    }

    @Override
    public Object getLiteralValue() {
        return this.relationalLiteralValue;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.relationalMapping.getJdbcMapping();
    }

    @Override
    public DomainResult<D> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        this.applySqlSelections(creationState);
        return new ConstantDomainResult<D>(this.domainLiteralValue, this.converter.getDomainJavaType(), resultVariable);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver expressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        expressionResolver.resolveSqlSelection(this, this.relationalMapping.getExpressibleJavaType(), null, sqlAstCreationState.getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        this.relationalMapping.getJdbcMapping().getJdbcValueBinder().bind(statement, this.relationalLiteralValue, startPosition, (WrapperOptions)executionContext.getSession());
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitConvertedQueryLiteral(this);
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.relationalMapping.getJdbcMapping();
    }

    private static class ConstantDomainResult<D>
    implements DomainResult<D>,
    DomainResultAssembler<D> {
        private final D literal;
        private final JavaType<D> javaType;
        private final String resultAlias;

        public ConstantDomainResult(D literal, JavaType<D> javaType, String resultAlias) {
            this.literal = literal;
            this.javaType = javaType;
            this.resultAlias = resultAlias;
        }

        @Override
        public String getResultVariable() {
            return this.resultAlias;
        }

        @Override
        public JavaType<?> getResultJavaType() {
            return this.javaType;
        }

        @Override
        public DomainResultAssembler<D> createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
            return this;
        }

        @Override
        public D assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            return this.literal;
        }

        @Override
        public JavaType<D> getAssembledJavaType() {
            return this.javaType;
        }
    }
}

