/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;
import org.hibernate.type.descriptor.java.JavaType;

public class EntityDelayedResultImpl
implements DomainResult {
    private final NavigablePath navigablePath;
    private final EntityAssociationMapping entityValuedModelPart;
    private final DomainResult identifierResult;

    public EntityDelayedResultImpl(NavigablePath navigablePath, EntityAssociationMapping entityValuedModelPart, TableGroup rootTableGroup, DomainResultCreationState creationState) {
        this.navigablePath = navigablePath;
        this.entityValuedModelPart = entityValuedModelPart;
        this.identifierResult = entityValuedModelPart.getForeignKeyDescriptor().createKeyDomainResult(navigablePath.append("{id}"), rootTableGroup, null, creationState);
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.entityValuedModelPart.getAssociatedEntityMappingType().getMappedJavaType();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public String getResultVariable() {
        return null;
    }

    public DomainResultAssembler createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        EntityInitializer initializer = (EntityInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.entityValuedModelPart, () -> new EntityDelayedFetchInitializer(null, this.getNavigablePath(), (ToOneAttributeMapping)this.entityValuedModelPart, false, this.identifierResult.createResultAssembler(parentAccess, creationState)));
        return new EntityAssembler(this.getResultJavaType(), initializer);
    }

    public String toString() {
        return "EntityDelayedResultImpl {" + this.getNavigablePath() + "}";
    }
}

